/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.databinding.viewers.ViewerValueProperty;
import org.eclipse.jface.internal.databinding.viewers.SelectionChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class SelectionProviderSingleSelectionProperty<S extends ISelectionProvider, T>
extends ViewerValueProperty<S, T> {
    private final boolean isPostSelection;
    private final Object valueType;

    public SelectionProviderSingleSelectionProperty(boolean isPostSelection, Object valueType) {
        this.isPostSelection = isPostSelection;
        this.valueType = valueType;
    }

    public SelectionProviderSingleSelectionProperty(boolean isPostSelection) {
        this(isPostSelection, null);
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected T doGetValue(ISelectionProvider source) {
        ISelection selection = source.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (T)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected void doSetValue(ISelectionProvider source, Object value) {
        StructuredSelection selection;
        StructuredSelection structuredSelection = selection = value == null ? StructuredSelection.EMPTY : new StructuredSelection(value);
        if (source instanceof Viewer) {
            ((Viewer)source).setSelection((ISelection)selection, true);
        } else {
            source.setSelection((ISelection)selection);
        }
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
        return new SelectionChangedListener<S, ValueDiff<? extends T>>((IProperty)this, listener, this.isPostSelection);
    }

    public String toString() {
        return this.isPostSelection ? "IPostSelectionProvider.postSelection" : "ISelectionProvider.selection";
    }
}

