/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.VerificationSnapshotAction;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.rcptt.ui.verification.VerificationUIManager;
import org.eclipse.rcptt.ui.verification.VerificationViewer;
import org.eclipse.rcptt.ui.wizards.WizardVerificationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class NewVerificationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardVerificationPage verificationPage;
    private IVerification verification;
    private boolean takeSnapshot = false;
    private final VerificationType type;
    private final String widgetClass;
    private final String selector;

    public NewVerificationWizard() {
        this(null, null, null);
    }

    public NewVerificationWizard(VerificationType type, String widgetClass, String selector) {
        this.setWindowTitle(Messages.NewVerificationWizard_WindowTitle);
        this.type = type;
        this.widgetClass = widgetClass;
        this.selector = selector;
    }

    public IVerification getVerification() {
        return this.verification;
    }

    public void setTakeSnapshot(boolean snapshot) {
        this.takeSnapshot = snapshot;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.verificationPage = new WizardVerificationPage(this.selection, this.type, this.widgetClass);
        this.verificationPage.setTakeSnapshot(this.takeSnapshot);
        this.addPage((IWizardPage)this.verificationPage);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            IProject project = this.verificationPage.getProject();
            VerificationType type = this.verificationPage.getVerificationType();
            String name = this.verificationPage.getVerificationName();
            IPath containerPath = this.verificationPage.getPathInProject();
            IQ7Folder folder = RcpttCore.create((IProject)project).getFolder(containerPath);
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(this.getShell());
            if (!writeAccessChecker.makeResourceWritable(folder.getResource())) {
                return false;
            }
            this.verification = folder.createVerification(name, type, true, (IProgressMonitor)new NullProgressMonitor());
            if (!this.takeSnapshot) {
                IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)((IFile)this.verification.getResource()));
                return true;
            }
            VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(type);
            IQ7NamedElement workingCopy = this.verification.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                final IQ7Editor<Verification> editor = viewer.getViewer().createEditor();
                editor.setElement(workingCopy);
                VerificationSnapshotAction action = new VerificationSnapshotAction(this.getShell(), editor, this.selector);
                action.setJoin(true);
                action.run();
                if (action.getStatus().getSeverity() == 8) {
                    workingCopy.discardWorkingCopy();
                    workingCopy = null;
                    new DeleteResourceChange(this.verification.getPath(), true, true).perform((IProgressMonitor)new NullProgressMonitor());
                    return false;
                }
                IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        editor.save();
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
                    if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{workingCopy})) {
                        editor.dispose();
                        return false;
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e.getCause());
                    editor.dispose();
                    return true;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    workingCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                    return true;
                }
            }
            finally {
                if (workingCopy != null) {
                    workingCopy.discardWorkingCopy();
                }
            }
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
            return false;
        }
    }

    private IWorkbenchPage getPage() {
        return this.workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public IProject getProject() {
        return this.verificationPage.getProject();
    }
}

