/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.rcptt.core.ecl.parser.model.OccurrencesSettings;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class ECLEditorPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.ui.editors.ecl";
    public static final String ECL_CONTENT_ASSIST_DELAY = "ECL_CONTENT_ASSIST_DELAY";
    public static final String ECL_CONTENT_ASSIST_TRIGGERS = "ECL_CONTENT_ASSIST_TRIGGERS";
    public static final String ECL_CONTENT_ASSIST_ACTIVATIONSTATE = "ECL_CONTENT_ASSIST_ACTIVATIONSTATE";
    public static final int DEFAULT_ECL_CONTENT_ASSIST_DELAY = 200;
    public static final String DEFAULT_ECL_CONTENT_ASSIST_TRIGGERS = " -[$";
    public static final int DEFAULT_ECL_CONTENT_ASSIST_ACTIVATION_STATE = 1;

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static int getECLScriptContentAssistDelay() {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        return preferences.getInt(ECL_CONTENT_ASSIST_DELAY, 200);
    }

    public static void setECLScriptContentAssistDelay(int delay) {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        preferences.putInt(ECL_CONTENT_ASSIST_DELAY, delay);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getECLScriptContentAssistTriggers() {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        return preferences.get(ECL_CONTENT_ASSIST_TRIGGERS, DEFAULT_ECL_CONTENT_ASSIST_TRIGGERS);
    }

    public static void setECLScriptContentAssistTriggers(String triggers) {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        preferences.put(ECL_CONTENT_ASSIST_TRIGGERS, triggers);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getECLScriptContentAssistActivationState() {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        return preferences.getInt(ECL_CONTENT_ASSIST_ACTIVATIONSTATE, 1) == 1;
    }

    public static void setECLScriptContentAssistActivationState(int state) {
        IEclipsePreferences preferences = ECLEditorPlugin.getPreferences();
        preferences.putInt(ECL_CONTENT_ASSIST_ACTIVATIONSTATE, state);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IEclipsePreferences getPrefs() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static OccurrencesSettings getMarkSettings() {
        return OccurrencesSettings.fromPrefs((IEclipsePreferences)ECLEditorPlugin.getPreferences());
    }

    public static void setMarkSettings(OccurrencesSettings settings) {
        IEclipsePreferences prefs = ECLEditorPlugin.getPrefs();
        settings.toPrefs(prefs);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Q7UIPlugin.log("Error saving preferences", e);
        }
    }
}

