/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class ColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private int direction = 0;
    private final TableViewerColumn column;
    private final ColumnViewer viewer;

    public ColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
        this.column = column;
        this.viewer = viewer;
        this.column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnViewerSorter.this.viewer.getComparator() != null) {
                    if (ColumnViewerSorter.this.viewer.getComparator() == ColumnViewerSorter.this) {
                        int tdirection = ColumnViewerSorter.this.direction;
                        if (tdirection == 1) {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, -1);
                        } else if (tdirection == -1) {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 0);
                        }
                    } else {
                        ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                    }
                } else {
                    ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                }
            }
        });
    }

    public void setSorter(ColumnViewerSorter sorter, int direction) {
        if (direction == 0) {
            this.column.getColumn().getParent().setSortColumn(null);
            this.column.getColumn().getParent().setSortDirection(0);
            this.viewer.setComparator(null);
        } else {
            this.column.getColumn().getParent().setSortColumn(this.column.getColumn());
            sorter.direction = direction;
            if (direction == 1) {
                this.column.getColumn().getParent().setSortDirection(1024);
            } else {
                this.column.getColumn().getParent().setSortDirection(128);
            }
            if (this.viewer.getComparator() == sorter) {
                this.viewer.refresh();
            } else {
                this.viewer.setComparator((ViewerComparator)sorter);
            }
        }
        this.afterSort();
    }

    public int compare(Viewer viewer, Object element1, Object element2) {
        return this.direction * this.doCompare(viewer, element1, element2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);

    protected abstract void afterSort();
}

