/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bndtools.templating.Resource;
import org.bndtools.templating.ResourceMap;
import org.bndtools.templating.Template;
import org.bndtools.templating.TemplateEngine;
import org.bndtools.templating.util.ObjectClassDefinitionImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.metatype.ObjectClassDefinition;

public class BuiltInTemplate
implements Template {
    private final Bundle bundle = FrameworkUtil.getBundle(BuiltInTemplate.class);
    private final ResourceMap inputResources = new ResourceMap();
    private final String name;
    private final String engineName;
    private final Version version = Version.parseVersion((String)"1.0.0");
    private URI helpUri = null;

    public BuiltInTemplate(String name, String templateEngine) {
        this.name = name;
        this.engineName = templateEngine;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return "built-in";
    }

    public String getCategory() {
        return "mmm/Bndtools";
    }

    public int getRanking() {
        return -1000;
    }

    public Version getVersion() {
        return this.version;
    }

    public ObjectClassDefinition getMetadata() throws Exception {
        return this.getMetadata((IProgressMonitor)new NullProgressMonitor());
    }

    public ObjectClassDefinition getMetadata(IProgressMonitor monitor) throws Exception {
        return new ObjectClassDefinitionImpl(this.name, this.getShortDescription(), null);
    }

    public ResourceMap generateOutputs(Map<String, List<Object>> parameters) throws Exception {
        return this.generateOutputs(parameters, (IProgressMonitor)new NullProgressMonitor());
    }

    public ResourceMap generateOutputs(Map<String, List<Object>> parameters, IProgressMonitor monitor) throws Exception {
        BundleContext context = this.bundle.getBundleContext();
        Collection svcRefs = context.getServiceReferences(TemplateEngine.class, String.format("(name=%s)", this.engineName));
        if (svcRefs == null || svcRefs.isEmpty()) {
            throw new Exception(String.format("Unable to generate built-in template '%s': no Template Engine available matching '%s'", this.name, this.engineName));
        }
        ServiceReference svcRef = (ServiceReference)svcRefs.iterator().next();
        TemplateEngine engine = (TemplateEngine)context.getService(svcRef);
        if (engine == null) {
            throw new Exception(String.format("Unable to generate built-in template '%s': no Template Engine available matching '%s'", this.name, this.engineName));
        }
        try {
            ResourceMap resourceMap = engine.generateOutputs(this.inputResources, parameters, monitor);
            return resourceMap;
        }
        finally {
            context.ungetService(svcRef);
        }
    }

    public void addInputResource(String path, Resource resource) {
        this.inputResources.put(path, resource);
    }

    public void setHelpPath(String path) {
        this.helpUri = this.getResourceURI(path);
    }

    public URI getIcon() {
        return this.getResourceURI("icons/template_empty.gif");
    }

    public URI getHelpContent() {
        return this.helpUri;
    }

    private URI getResourceURI(String path) {
        URI uri = null;
        URL url = this.bundle.getResource(path);
        if (url != null) {
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    public void close() throws IOException {
    }
}

