/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import java.io.IOException;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.jgit.lib.Repository;

public class GitCacheCompareInput
extends GitCompareInput {
    private final IFile baseFile;

    public GitCacheCompareInput(Repository repo, IFile baseFile, ComparisonDataSource ancestorDataSource, ComparisonDataSource baseDataSource, ComparisonDataSource remoteDataSource, String gitPath) {
        super(repo, ancestorDataSource, baseDataSource, remoteDataSource, gitPath);
        this.baseFile = baseFile;
    }

    @Override
    public ITypedElement getLeft() {
        try {
            return CompareUtils.getIndexTypedElement(this.baseFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ITypedElement getRight() {
        return CompareUtils.getFileRevisionTypedElement(this.gitPath, this.baseCommit, this.repo);
    }

    @Override
    public ITypedElement getAncestor() {
        return this.getRight();
    }
}

