/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class FileTreeContentProvider
implements ITreeContentProvider {
    private final Repository repository;
    private final List<Node> rootNodes = new ArrayList<Node>();
    private List<String> input;
    private Mode mode = Mode.REPO_RELATIVE_PATHS;
    private List<IPath> projectPaths;
    private Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private Image projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");

    public FileTreeContentProvider(Repository repository) {
        this.repository = repository;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Object[] getChildren(Object parent) {
        return ((Node)parent).getChildren().toArray();
    }

    public Object getParent(Object child) {
        return ((Node)child).getParent();
    }

    public boolean hasChildren(Object parent) {
        return ((Node)parent).hasChildren();
    }

    public Object[] getElements(Object arg0) {
        return this.rootNodes.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        VirtualNode virtualNode;
        this.rootNodes.clear();
        this.input = (List)newInput;
        if (this.input == null) {
            return;
        }
        FolderNode parentNode = virtualNode = new VirtualNode();
        NoResourceNode noResourceNode = null;
        Path repositoryRoot = new Path(this.repository.getWorkTree().getAbsolutePath());
        for (String pathString : this.input) {
            Object path = this.mode == Mode.FULL_PATHS ? repositoryRoot.append(pathString) : (this.mode == Mode.RESOURCE_PATHS ? this.resolveResourcePath(repositoryRoot.append(pathString)) : new Path(pathString));
            if (path == null) {
                path = repositoryRoot.append(pathString);
                if (noResourceNode == null) {
                    noResourceNode = new NoResourceNode(virtualNode, UIText.FileTreeContentProvider_NonWorkspaceResourcesNode);
                }
                parentNode = noResourceNode;
            } else {
                parentNode = virtualNode;
            }
            int i = 0;
            while (i < path.segmentCount()) {
                String segment = path.segment(i);
                Node foundNode = null;
                for (Node node : parentNode.getChildren()) {
                    if (!node.getName().equals(segment) || node instanceof FileNode) continue;
                    foundNode = node;
                    break;
                }
                if (foundNode == null) {
                    if (i < path.segmentCount() - 1) {
                        parentNode = new FolderNode(parentNode, segment);
                    } else {
                        new FileNode(parentNode, segment);
                    }
                } else {
                    parentNode = foundNode;
                }
                ++i;
            }
        }
        this.rootNodes.addAll(virtualNode.getChildren());
    }

    private IPath resolveResourcePath(IPath fullPath) {
        for (IPath projectPath : this.getProjectPaths()) {
            if (!projectPath.isPrefixOf(fullPath)) continue;
            return fullPath.removeFirstSegments(projectPath.segmentCount() - 1);
        }
        return null;
    }

    private List<IPath> getProjectPaths() {
        if (this.projectPaths == null) {
            this.projectPaths = new ArrayList<IPath>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
                if (mapping != null && mapping.getRepository().equals(this.repository)) {
                    this.projectPaths.add(project.getLocation());
                }
                ++n2;
            }
        }
        return this.projectPaths;
    }

    class FileNode
    extends Node {
        FileNode(Node parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public Image getImage() {
            return FileTreeContentProvider.this.fileImage;
        }
    }

    private class FolderNode
    extends Node {
        FolderNode(Node parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Image getImage() {
            if (FileTreeContentProvider.this.mode == Mode.RESOURCE_PATHS && this.getParent() instanceof VirtualNode) {
                return FileTreeContentProvider.this.projectImage;
            }
            return FileTreeContentProvider.this.folderImage;
        }
    }

    public static enum Mode {
        REPO_RELATIVE_PATHS,
        FULL_PATHS,
        RESOURCE_PATHS;

    }

    private class NoResourceNode
    extends Node {
        NoResourceNode(Node parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Image getImage() {
            return FileTreeContentProvider.this.folderImage;
        }
    }

    public abstract class Node {
        private final String myName;
        private final Node myParent;
        protected final List<Node> myChildren = new ArrayList<Node>();

        Node(Node parent, String name) {
            this.myParent = parent;
            this.myName = name;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public abstract boolean hasChildren();

        public abstract Image getImage();

        public String getName() {
            return this.myName;
        }

        public Node getParent() {
            return this.myParent;
        }

        private void addChild(Node child) {
            this.myChildren.add(child);
        }

        public List<Node> getChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            return null;
        }

        public String toString() {
            return this.myName;
        }
    }

    private class VirtualNode
    extends FolderNode {
        VirtualNode() {
            super(null, "");
        }

        @Override
        public boolean hasChildren() {
            return !this.myChildren.isEmpty();
        }
    }
}

