/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.gef;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.gef.describers.EditPartDescriber;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefEventRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.RecordingWidgetDescriber;
import org.eclipse.swt.widgets.Widget;

public class RecordingEditPartDescriber
extends EditPartDescriber
implements IRecordingDescriber {
    protected boolean needLogging;

    public RecordingEditPartDescriber(EditPart editPart, GraphicalViewer viewer) {
        super(editPart, viewer);
    }

    public Element searchForElement(TeslaRecorder recorder) {
        GefEventRecorder rec = (GefEventRecorder)recorder.getProcessor(GefEventRecorder.class);
        EditPartViewer viewer = this.getPart().getViewer();
        if (rec.isSkipDiagramOperations()) {
            return null;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = rec.getLocator().getDiagramUIElement(viewer);
        if (entry != null) {
            FigureUIElement element;
            if (this.needLogging && TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"assert engine", (String)("locking for identity for edit part: " + this.getPart().getClass().getName()));
            }
            if ((element = rec.getLocator().find(this.getPart(), viewer, entry.diagramViewer, false)) != null) {
                return element.getElement();
            }
        }
        return null;
    }

    public IRecordingDescriber getParent() {
        EditPart editPart = this.getPart();
        EditPart parent = editPart.getParent();
        if (parent != null) {
            return new RecordingEditPartDescriber(parent, this.getViewer());
        }
        return new RecordingWidgetDescriber((Widget)this.getViewer().getControl());
    }

    public void setNeedLogging(boolean need) {
        this.needLogging = need;
    }
}

