/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectSetContentHandler
extends DefaultHandler {
    boolean inPsf = false;
    boolean inProvider = false;
    boolean inProject = false;
    Map<String, List<String>> map;
    String id;
    List<String> references;
    boolean isVersionOne = false;

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String elementName = this.getElementName(namespaceURI, localName, qName);
        if (elementName.equals("psf")) {
            this.map = new HashMap<String, List<String>>();
            this.inPsf = true;
            String version = atts.getValue("version");
            this.isVersionOne = version.equals("1.0");
            return;
        }
        if (this.isVersionOne) {
            return;
        }
        if (elementName.equals("provider")) {
            if (!this.inPsf) {
                throw new SAXException(TeamUIMessages.ProjectSetContentHandler_Element_provider_must_be_contained_in_element_psf_4);
            }
            this.inProvider = true;
            this.id = atts.getValue("id");
            this.references = new ArrayList<String>();
            return;
        }
        if (elementName.equals("project")) {
            if (!this.inProvider) {
                throw new SAXException(TeamUIMessages.ProjectSetContentHandler_Element_project_must_be_contained_in_element_provider_7);
            }
            this.inProject = true;
            String reference = atts.getValue("reference");
            this.references.add(reference);
            return;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String elementName = this.getElementName(namespaceURI, localName, qName);
        if (elementName.equals("psf")) {
            this.inPsf = false;
            return;
        }
        if (this.isVersionOne) {
            return;
        }
        if (elementName.equals("provider")) {
            this.map.put(this.id, this.references);
            this.references = null;
            this.inProvider = false;
            return;
        }
        if (elementName.equals("project")) {
            this.inProject = false;
            return;
        }
    }

    public Map<String, List<String>> getReferences() {
        return this.map;
    }

    public boolean isVersionOne() {
        return this.isVersionOne;
    }

    private String getElementName(String namespaceURI, String localName, String qName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        return qName;
    }
}

