/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.8")
public interface Named<T> {
    public static <T> Named<T> of(final String name, final T payload) {
        Preconditions.notBlank((String)name, (String)"name must not be null or blank");
        return new Named<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public T getPayload() {
                return payload;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <T> Named<T> named(String name, T payload) {
        return Named.of(name, payload);
    }

    public String getName();

    public T getPayload();
}

