/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;

class AssertEquals {
    private AssertEquals() {
    }

    static void assertEquals(byte expected, byte actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(byte expected, byte actual, String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(char expected, char actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(char expected, char actual, String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(Character.valueOf(expected), Character.valueOf(actual), message);
        }
    }

    static void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(Character.valueOf(expected), Character.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(double expected, double actual, String message) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual, double delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(double expected, double actual, double delta, String message) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(double expected, double actual, double delta, Supplier<String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(float expected, float actual, String message) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), message);
        }
    }

    static void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual, float delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(float expected, float actual, float delta, String message) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), message);
        }
    }

    static void assertEquals(float expected, float actual, float delta, Supplier<String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(short expected, short actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(short expected, short actual, String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(int expected, int actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(int expected, int actual, String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(long expected, long actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(long expected, long actual, String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(Object expected, Object actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(Object expected, Object actual, String message) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    private static void failNotEqual(Object expected, Object actual, Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(expected).actual(actual).buildAndThrow();
    }
}

