/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.CatchAllValue;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.ProfileManager;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class PDEState
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private static final String[] MANIFEST_ENTRIES = new String[]{"Bundle-Localization", "Bundle-Name", "Bundle-Vendor", "Eclipse-BundleShape", "Eclipse-SourceBundle", "Eclipse-SourceReferences"};
    private StateObjectFactory factory = Platform.getPlatformAdmin().getFactory();
    protected State state = this.factory.createState(false);
    private long id;
    private Properties repositoryVersions;
    private Properties sourceReferences;
    private HashMap<Long, String[]> bundleClasspaths;
    private ProfileManager profileManager;
    private Map<Long, String> patchBundles;
    private List<BundleDescription> addedBundle;
    private List<BundleDescription> unqualifiedBundles;
    private Properties platformProperties;
    private List<BundleDescription> sortedBundles = null;
    private final Set<Dictionary<String, String>> convertedManifests;
    private long lastSortingDate = 0L;
    private String[] eeSources;

    protected long getNextId() {
        return ++this.id;
    }

    public PDEState(PDEUIStateWrapper initialState) {
        this();
        this.state = initialState.getState();
        this.factory = this.state.getFactory();
        this.id = initialState.getNextId();
        this.bundleClasspaths = initialState.getClasspaths();
        this.patchBundles = initialState.getPatchData();
        this.addedBundle = new ArrayList<BundleDescription>();
        this.unqualifiedBundles = new ArrayList<BundleDescription>();
    }

    public PDEState() {
        this.state.setResolver(Platform.getPlatformAdmin().createResolver());
        this.id = 0L;
        this.bundleClasspaths = new HashMap();
        this.patchBundles = new HashMap<Long, String>();
        this.convertedManifests = new HashSet<Dictionary<String, String>>(2);
        this.loadPluginTagFile();
        this.loadSourceReferences();
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public boolean addBundleDescription(BundleDescription toAdd) {
        return this.state.addBundle(toAdd);
    }

    public boolean addBundle(Dictionary<String, String> enhancedManifest, File bundleLocation) {
        String oldVersion = this.updateVersionNumber(enhancedManifest);
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.bundleClasspaths.put(new Long(descriptor.getBundleId()), BundleHelper.getClasspath(enhancedManifest));
            String patchValue = this.fillPatchData(enhancedManifest);
            if (patchValue != null) {
                this.patchBundles.put(new Long(descriptor.getBundleId()), patchValue);
            }
            this.rememberQualifierTagPresence(descriptor);
            this.rememberManifestConversion(descriptor, enhancedManifest);
            this.rememberManifestEntries(descriptor, enhancedManifest, MANIFEST_ENTRIES);
            this.rememberSourceReference(descriptor, oldVersion);
            if (this.addBundleDescription(descriptor) && this.addedBundle != null) {
                this.addedBundle.add(descriptor);
            }
        }
        catch (BundleException e) {
            Status status = new Status(2, "org.eclipse.pde.build", 15, NLS.bind((String)Messages.exception_stateAddition, (Object)BundleHelper.getManifestHeader(enhancedManifest, "Bundle-Name")), (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    private void rememberQualifierTagPresence(BundleDescription descriptor) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("qualifier", "marker");
    }

    private void rememberSourceReference(BundleDescription descriptor, String oldVersion) {
        if (this.sourceReferences == null) {
            return;
        }
        String key = QualifierReplacer.getQualifierKey(descriptor.getSymbolicName(), oldVersion);
        if (key == null || !this.sourceReferences.containsKey(key)) {
            key = String.valueOf(descriptor.getSymbolicName()) + ',' + Version.emptyVersion.toString();
        }
        if (this.sourceReferences.containsKey(key)) {
            Properties bundleProperties = (Properties)descriptor.getUserObject();
            if (bundleProperties == null) {
                bundleProperties = new Properties();
                descriptor.setUserObject((Object)bundleProperties);
            }
            bundleProperties.setProperty("sourceReference", this.sourceReferences.getProperty(key));
        }
    }

    private void rememberManifestEntries(BundleDescription descriptor, Dictionary<String, String> manifest, String[] entries) {
        if (entries == null || entries.length == 0) {
            return;
        }
        Properties properties = (Properties)descriptor.getUserObject();
        if (properties == null) {
            properties = new Properties();
            descriptor.setUserObject((Object)properties);
        }
        int i = 0;
        while (i < entries.length) {
            String entry = BundleHelper.getManifestHeader(manifest, entries[i]);
            if (entry != null) {
                properties.put(entries[i], entry);
            }
            ++i;
        }
    }

    private void rememberManifestConversion(BundleDescription descriptor, Dictionary<String, String> manifest) {
        if (this.convertedManifests == null || !this.convertedManifests.contains(manifest)) {
            return;
        }
        this.convertedManifests.remove(manifest);
        Properties bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("convertedManifest", "marker");
    }

    private void mapVersionReplacedBundle(BundleDescription oldBundle, BundleDescription newBundle) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)oldBundle.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            oldBundle.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("versionReplacement", String.valueOf(newBundle.getBundleId()));
    }

    private String fillPatchData(Dictionary<String, String> manifest) {
        if (BundleHelper.getManifestHeader(manifest, "Eclipse-ExtensibleAPI") != null) {
            return "Eclipse-ExtensibleAPI: true";
        }
        if (BundleHelper.getManifestHeader(manifest, "Eclipse-PatchFragment") != null) {
            return "Eclipse-PatchFragment: true";
        }
        return null;
    }

    private void loadPluginTagFile() {
        this.repositoryVersions = new Properties();
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(String.valueOf(AbstractScriptGenerator.getWorkingDirectory()) + '/' + "pluginVersions.properties"));){
                this.repositoryVersions.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void loadSourceReferences() {
        this.sourceReferences = new Properties();
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(String.valueOf(AbstractScriptGenerator.getWorkingDirectory()) + '/' + "sourceReferences.properties"));){
                this.sourceReferences.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean addBundle(File bundleLocation) {
        Dictionary<String, String> manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return this.addFlexibleRoot(bundleLocation);
        }
        try {
            this.hasQualifier(bundleLocation, manifest);
        }
        catch (BundleException bundleException) {}
        return this.addBundle(manifest, bundleLocation);
    }

    private boolean addFlexibleRoot(File bundleLocation) {
        if (!new File(bundleLocation, ".settings/org.eclipse.pde.core.prefs").exists()) {
            return false;
        }
        try {
            Properties properties = AbstractScriptGenerator.readProperties(bundleLocation.getAbsolutePath(), ".settings/org.eclipse.pde.core.prefs", 0);
            String root = properties.getProperty("BUNDLE_ROOT_PATH");
            if (root != null) {
                return this.addBundle(new File(bundleLocation, root));
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private String updateVersionNumber(Dictionary<String, String> manifest) {
        String symbolicName;
        String oldVersion;
        String newVersion;
        block4: {
            newVersion = null;
            oldVersion = null;
            try {
                symbolicName = BundleHelper.getManifestHeader(manifest, "Bundle-SymbolicName");
                if (symbolicName != null) break block4;
                return null;
            }
            catch (BundleException bundleException) {}
        }
        symbolicName = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName)[0].getValue();
        oldVersion = BundleHelper.getManifestHeader(manifest, "Bundle-Version");
        newVersion = QualifierReplacer.replaceQualifierInVersion(oldVersion, symbolicName, manifest.get("qualifier"), this.repositoryVersions);
        if (newVersion != null) {
            manifest.put("Bundle-Version", newVersion);
        }
        return oldVersion;
    }

    private void hasQualifier(File bundleLocation, Dictionary<String, String> manifest) throws BundleException {
        ManifestElement[] versionInfo = ManifestElement.parseHeader((String)"Bundle-Version", (String)BundleHelper.getManifestHeader(manifest, "Bundle-Version"));
        if (versionInfo != null && versionInfo[0].getValue().endsWith("qualifier")) {
            manifest.put("qualifier", this.getQualifierPropery(bundleLocation.getAbsolutePath()));
        }
    }

    private String getQualifierPropery(String bundleLocation) {
        String qualifierInfo = null;
        try {
            qualifierInfo = AbstractScriptGenerator.readProperties(bundleLocation, "build.properties", 1).getProperty("qualifier");
        }
        catch (CoreException coreException) {}
        if (qualifierInfo == null) {
            qualifierInfo = "context";
        }
        return qualifierInfo;
    }

    /*
     * Unable to fully structure code
     */
    private Dictionary<String, String> basicLoadManifest(File bundleLocation) {
        manifestStream = null;
        jarFile = null;
        try {
            if ("jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                manifestStream = new BufferedInputStream(new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF")));
            }
        }
        catch (IOException v0) {}
        if (manifestStream == null) {
            return null;
        }
        result = new Hashtable<String, String>();
        result.putAll(ManifestElement.parseBundleManifest((InputStream)manifestStream, null));
        var6_5 = result;
        try {
            manifestStream.close();
        }
        catch (IOException v1) {}
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException v2) {}
        return var6_5;
        catch (IOException v3) {
            ** try [egrp 4[TRYBLOCK] [10 : 150->151)] { 
lbl31:
            // 1 sources

            try {
                manifestStream.close();
            }
            catch (IOException v4) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException v5) {}
            return null;
        }
        catch (BundleException v6) {
            ** try [egrp 7[TRYBLOCK] [11 : 173->174)] { 
lbl-1000:
            // 3 sources

            {
                catch (Throwable var5_6) {
                    try {
                        manifestStream.close();
                    }
                    catch (IOException v7) {}
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException v8) {}
                    throw var5_6;
                }
            }
lbl54:
            // 1 sources

            try {
                manifestStream.close();
            }
            catch (IOException v9) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException v10) {}
            return null;
        }
    }

    private boolean enforceSymbolicName(File bundleLocation, Dictionary<String, String> initialManifest) {
        return BundleHelper.getManifestHeader(initialManifest, "Bundle-SymbolicName") != null;
    }

    private void enforceClasspath(Dictionary<String, String> manifest) {
        String classpath = BundleHelper.getManifestHeader(manifest, "Bundle-ClassPath");
        if (classpath == null) {
            manifest.put("Bundle-ClassPath", ".");
        }
    }

    private void enforceVersion(Dictionary<String, String> manifest) {
        String version = BundleHelper.getManifestHeader(manifest, "Bundle-Version");
        if (version == null) {
            manifest.put("Bundle-Version", "0.0.0");
        }
    }

    private Dictionary<String, String> loadManifest(File bundleLocation) {
        Dictionary<String, String> manifest = this.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        if (!this.enforceSymbolicName(bundleLocation, manifest)) {
            return null;
        }
        this.enforceVersion(manifest);
        this.enforceClasspath(manifest);
        return manifest;
    }

    public void addBundles(Collection<File> bundles) {
        for (File bundle : bundles) {
            this.addBundle(bundle);
        }
    }

    public void resolveState() {
        Hashtable<String, Object> prop;
        List<Config> configs = AbstractScriptGenerator.getConfigInfos();
        ArrayList properties = new ArrayList();
        String[] javaProfiles = this.getJavaProfiles();
        String systemPackages = null;
        String ee = null;
        for (Config aConfig : configs) {
            prop = new Hashtable<String, Object>();
            if (AbstractScriptGenerator.getPropertyAsBoolean("resolution.devMode")) {
                ((Dictionary)prop).put("osgi.resolverMode", "development");
            }
            String os = aConfig.getOs();
            String ws = aConfig.getWs();
            String arch = aConfig.getArch();
            if (Config.ANY.equalsIgnoreCase(os)) {
                ((Dictionary)prop).put("osgi.os", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.os", os);
            }
            if (Config.ANY.equalsIgnoreCase(ws)) {
                ((Dictionary)prop).put("osgi.ws", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.ws", ws);
            }
            if (Config.ANY.equalsIgnoreCase(arch)) {
                ((Dictionary)prop).put("osgi.arch", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.arch", arch);
            }
            if (this.platformProperties != null) {
                Enumeration<Object> e = this.platformProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ((Dictionary)prop).put(key, this.platformProperties.get(key));
                }
            }
            properties.add(prop);
        }
        Properties profileProps = null;
        boolean added = false;
        String eeJava9 = null;
        int j = javaProfiles.length - 1;
        while (j >= 0) {
            String profileName;
            profileProps = this.profileManager.getProfileProperties(javaProfiles[j]);
            if (profileProps != null && (AbstractScriptGenerator.getImmutableAntProperty(profileName = profileProps.getProperty("osgi.java.profile.name")) != null || j == 0 && !added)) {
                systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
                ee = profileProps.getProperty("org.osgi.framework.executionenvironment");
                prop = new Hashtable();
                ((Dictionary)prop).put("org.osgi.framework.system.packages", systemPackages);
                if (profileName.equals("JavaSE-9")) {
                    eeJava9 = ee;
                }
                ((Dictionary)prop).put("org.osgi.framework.executionenvironment", ee);
                properties.add(prop);
                added = true;
            }
            --j;
        }
        String[] java10AndBeyond = new String[]{"JavaSE-10", "JavaSE-11"};
        prop = new Hashtable();
        String previousEE = eeJava9;
        int i = 0;
        while (i <= java10AndBeyond.length - 1) {
            String execEnvID = java10AndBeyond[i];
            prop = new Hashtable();
            Properties javaProfilePropertiesForVMPackage = PDEState.getJavaProfilePropertiesForVMPackage(execEnvID);
            if (javaProfilePropertiesForVMPackage != null) {
                systemPackages = javaProfilePropertiesForVMPackage.getProperty("org.osgi.framework.system.packages");
            }
            String currentEE = String.valueOf(previousEE) + "," + execEnvID;
            if (systemPackages == null) {
                previousEE = currentEE;
            } else {
                ((Dictionary)prop).put("org.osgi.framework.system.packages", systemPackages);
                ((Dictionary)prop).put("org.osgi.framework.executionenvironment", currentEE);
                previousEE = currentEE;
                properties.add(prop);
            }
            ++i;
        }
        Dictionary[] stateProperties = properties.toArray(new Dictionary[properties.size()]);
        this.state.setPlatformProperties(stateProperties);
        this.state.resolve(false);
        if (this.unqualifiedBundles != null) {
            this.forceQualifiers();
        }
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.state.getBundle(bundleId, version);
        return PDEState.getDependentBundles(root);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if (!root.getLocation().equals(packages[i].getExporter().getLocation()) && !resolvedImports.contains(packages[i].getExporter())) {
                resolvedImports.add(packages[i].getExporter());
            }
            ++i;
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        return this.getBundle(bundleId, version, true);
    }

    public BundleDescription getBundle(String bundleId, String version, boolean resolved) {
        if ("0.0.0".equals(version) || version == null) {
            BundleDescription bundle = this.getResolvedBundle(bundleId);
            if (bundle == null && !resolved) {
                bundle = this.getState().getBundle(bundleId, null);
            }
            return bundle;
        }
        Version parsedVersion = Version.parseVersion((String)version);
        BundleDescription description = this.getState().getBundle(bundleId, parsedVersion);
        if (description != null && (!resolved || description.isResolved())) {
            return description;
        }
        if (parsedVersion.getQualifier().indexOf("qualifier") > -1) {
            BundleDescription[] bundles = this.sortByVersion(this.getState().getBundles(bundleId));
            VersionRange qualifierRange = Utils.createVersionRange(version);
            int i = bundles.length - 1;
            while (i >= 0) {
                if (qualifierRange.isIncluded(bundles[i].getVersion()) && (!resolved || bundles[i].isResolved())) {
                    return bundles[i];
                }
                --i;
            }
        }
        return null;
    }

    private BundleDescription[] sortByVersion(BundleDescription[] bundles) {
        if (bundles.length > 1) {
            Arrays.sort(bundles, new Comparator<BundleDescription>(){

                @Override
                public int compare(BundleDescription o1, BundleDescription o2) {
                    return o1.getVersion().compareTo(o2.getVersion());
                }
            });
        }
        return bundles;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.sortByVersion(this.getState().getBundles(bundleId));
        if (description == null) {
            return null;
        }
        int i = description.length - 1;
        while (i >= 0) {
            if (description[i].isResolved()) {
                return description[i];
            }
            --i;
        }
        return null;
    }

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEState.getImportedByFragments(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEState.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList<BundleDescription> importedByFragments = new ArrayList<BundleDescription>();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getImportedBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList<BundleDescription> importedByFragments = new ArrayList<BundleDescription>();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getRequiredBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List<BundleDescription> source, BundleDescription[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (!source.contains(toAdd[i])) {
                source.add(toAdd[i]);
            }
            ++i;
        }
    }

    public Properties loadPropertyFileIn(Map<String, String> toMerge, File location) {
        Properties result = new Properties();
        result.putAll(toMerge);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedInputStream propertyStream = new BufferedInputStream(new FileInputStream(new File(location, "build.properties")));){
                result.load(propertyStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public HashMap<Long, String[]> getExtraData() {
        return this.bundleClasspaths;
    }

    public Map<Long, String> getPatchData() {
        return this.patchBundles;
    }

    public List<BundleDescription> getSortedBundles() {
        if (this.lastSortingDate != this.getState().getTimeStamp()) {
            this.lastSortingDate = this.getState().getTimeStamp();
            BundleDescription[] toSort = this.getState().getResolvedBundles();
            Platform.getPlatformAdmin().getStateHelper().sortBundles(toSort);
            this.sortedBundles = Arrays.asList(toSort);
        }
        return this.sortedBundles;
    }

    public void cleanupOriginalState() {
        if (this.addedBundle == null && this.unqualifiedBundles == null) {
            return;
        }
        for (BundleDescription added : this.addedBundle) {
            this.state.removeBundle(added);
        }
        this.addedBundle.clear();
        for (BundleDescription toAddBack : this.unqualifiedBundles) {
            this.state.removeBundle(toAddBack.getBundleId());
            this.addBundleDescription(toAddBack);
        }
        this.unqualifiedBundles.clear();
        BundleDescription[] allBundles = this.state.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            allBundles[i].setUserObject(null);
            ++i;
        }
        this.state.resolve();
    }

    private File getOSGiLocation() {
        BundleDescription osgiBundle = this.state.getBundle("org.eclipse.osgi", null);
        if (osgiBundle == null) {
            return null;
        }
        return new File(osgiBundle.getLocation());
    }

    private String[] getJavaProfiles() {
        return this.getProfileManager().getJavaProfiles();
    }

    private void forceQualifiers() {
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        int i = 0;
        while (i < resolvedBundles.length) {
            if (resolvedBundles[i].getVersion().getQualifier().endsWith("qualifier")) {
                BundleDescription b = resolvedBundles[i];
                this.unqualifiedBundles.add(this.state.removeBundle(b.getBundleId()));
                String newVersion = QualifierReplacer.replaceQualifierInVersion(b.getVersion().toString(), b.getSymbolicName(), this.getQualifierPropery(b.getLocation()), null);
                BundleDescription newBundle = this.state.getFactory().createBundleDescription(b.getBundleId(), b.getSymbolicName(), new Version(newVersion), b.getLocation(), b.getRequiredBundles(), b.getHost(), b.getImportPackages(), b.getExportPackages(), b.isSingleton(), b.attachFragments(), b.dynamicFragments(), b.getPlatformFilter(), b.getExecutionEnvironments(), b.getGenericRequires(), b.getGenericCapabilities(), b.getNativeCodeSpecification());
                this.addBundleDescription(newBundle);
                this.rememberQualifierTagPresence(newBundle);
                this.mapVersionReplacedBundle(b, newBundle);
            }
            ++i;
        }
        this.state.resolve();
    }

    public BundleDescription getVersionReplacement(BundleDescription bundle) {
        Properties props = (Properties)bundle.getUserObject();
        if (props == null) {
            return bundle;
        }
        String idString = props.getProperty("versionReplacement");
        if (idString == null) {
            return bundle;
        }
        try {
            long newId = Long.parseLong(idString);
            BundleDescription newBundle = this.state.getBundle(newId);
            if (newBundle != null) {
                return newBundle;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return bundle;
    }

    public void setPlatformProperties(Properties platformProperties) {
        this.platformProperties = platformProperties;
    }

    public void setEESources(String[] eeSources) {
        this.eeSources = eeSources;
    }

    public ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            File osgi = this.getOSGiLocation();
            String[] sources = null;
            if (osgi != null) {
                if (this.eeSources != null) {
                    sources = new String[this.eeSources.length + 1];
                    sources[0] = osgi.getAbsolutePath();
                    System.arraycopy(this.eeSources, 0, sources, 1, this.eeSources.length);
                } else {
                    sources = new String[]{osgi.getAbsolutePath()};
                }
                this.profileManager = new ProfileManager(sources, false);
            } else {
                this.profileManager = new ProfileManager(this.eeSources, true);
            }
        }
        return this.profileManager;
    }

    private static Properties getJavaProfilePropertiesForVMPackage(String ee) {
        Bundle apitoolsBundle = Platform.getBundle((String)"org.eclipse.pde.api.tools");
        if (apitoolsBundle == null) {
            return null;
        }
        URL systemPackageProfile = apitoolsBundle.getEntry("system_packages/" + ee.replace('/', '_') + "-systempackages.profile");
        if (systemPackageProfile != null) {
            return PDEState.getPropertiesFromURL(systemPackageProfile);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static Properties getPropertiesFromURL(URL profileURL) {
        block17: {
            InputStream is;
            block16: {
                is = null;
                profileURL = FileLocator.resolve((URL)profileURL);
                URLConnection openConnection = profileURL.openConnection();
                openConnection.setUseCaches(false);
                is = openConnection.getInputStream();
                if (is == null) break block16;
                Properties profile = new Properties();
                profile.load(is);
                Properties properties = profile;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                return properties;
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException3) {}
                    break block17;
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

