/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.AutLaunch;

public abstract class DataExecutable
extends Executable {
    protected IQ7NamedElement element;
    protected AutLaunch launch;
    protected boolean terminateUser = false;
    protected NullProgressMonitor executionMonitor;

    public DataExecutable(AutLaunch launch, IQ7NamedElement element, boolean debug) {
        this(launch, element, debug, ExecutionPhase.AUTO);
    }

    public DataExecutable(AutLaunch launch, IQ7NamedElement element, boolean debug, ExecutionPhase phase) {
        super(debug, phase, false);
        this.element = element;
        this.launch = launch;
        this.executionMonitor = new NullProgressMonitor();
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public String getName() {
        String nameByDocument = Q7SearchCore.findNameByDocument((IQ7Element)this.element);
        if (nameByDocument != null) {
            return nameByDocument;
        }
        try {
            return this.element.getElementName();
        }
        catch (ModelException modelException) {
            if (!this.element.getResource().exists()) {
                return "Resource: " + this.element.getResource().getFullPath() + " doesn't exist.";
            }
            return "Unresolved element";
        }
    }

    @Override
    public String getId() {
        try {
            String id = Q7SearchCore.findIDByDocument((IQ7Element)this.element);
            if (id == null) {
                id = this.element.getID();
            }
            return id;
        }
        catch (ModelException e) {
            Q7LaunchingPlugin.log(e);
            return null;
        }
    }

    @Override
    public Executable[] getChildren() {
        return EMPTY;
    }

    @Override
    public IStatus execute() throws InterruptedException {
        try {
            return this.doExecute();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public boolean isTerminateUser() {
        return this.terminateUser;
    }

    protected abstract IStatus doExecute() throws CoreException, InterruptedException;

    @Override
    public IQ7NamedElement getActualElement() {
        return this.element;
    }
}

