/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class WizardExportResourcesPage
extends WizardDataTransferPage {
    private IStructuredSelection initialResourceSelection;
    private List selectedTypes = new ArrayList();
    private ResourceTreeAndListGroup resourceGroup;
    private static final String SELECT_TYPES_TITLE = IDEWorkbenchMessages.WizardTransferPage_selectTypes;
    private static final String SELECT_ALL_TITLE = IDEWorkbenchMessages.WizardTransferPage_selectAll;
    private static final String DESELECT_ALL_TITLE = IDEWorkbenchMessages.WizardTransferPage_deselectAll;

    protected WizardExportResourcesPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.initialResourceSelection = selection;
    }

    @Override
    protected boolean allowNewContainerName() {
        return false;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        button.setFont(parent.getFont());
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Font font = parent.getFont();
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardExportResourcesPage.this.handleTypesEditButtonPressed();
            }
        };
        selectTypesButton.addSelectionListener((SelectionListener)listener);
        selectTypesButton.setFont(font);
        this.setButtonLayoutData(selectTypesButton);
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardExportResourcesPage.this.resourceGroup.setAllSelections(true);
                WizardExportResourcesPage.this.updateWidgetEnablements();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        selectButton.setFont(font);
        this.setButtonLayoutData(selectButton);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardExportResourcesPage.this.resourceGroup.setAllSelections(false);
                WizardExportResourcesPage.this.updateWidgetEnablements();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        deselectButton.setFont(font);
        this.setButtonLayoutData(deselectButton);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createResourcesGroup(composite);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected abstract void createDestinationGroup(Composite var1);

    protected final void createResourcesGroup(Composite parent) {
        ArrayList<IProject> input = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                input.add(projects[i]);
            }
            ++i;
        }
        this.resourceGroup = new ResourceTreeAndListGroup(parent, input, this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode(parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardExportResourcesPage.this.updateWidgetEnablements();
            }
        };
        this.resourceGroup.addCheckStateListener(listener);
    }

    @Override
    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_errorDialogTitle;
    }

    @Deprecated
    protected boolean ensureResourcesLocal(List resources) {
        return true;
    }

    protected List extractNonLocalResources(List originalList) {
        Vector<IResource> result = new Vector<IResource>(originalList.size());
        for (IResource currentResource : originalList) {
            if (currentResource.isLocal(0)) continue;
            result.addElement(currentResource);
        }
        return result;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected List getSelectedResources() {
        Iterator resourcesToExportIterator = this.getSelectedResourcesIterator();
        ArrayList resourcesToExport = new ArrayList();
        while (resourcesToExportIterator.hasNext()) {
            resourcesToExport.add(resourcesToExportIterator.next());
        }
        return resourcesToExport;
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.resourceGroup.getAllCheckedListItems().iterator();
    }

    protected List getTypesToExport() {
        return this.selectedTypes;
    }

    protected List getWhiteCheckedResources() {
        return this.resourceGroup.getAllWhiteCheckedItems();
    }

    protected void handleTypesEditButtonPressed() {
        Object[] newSelectedTypes = this.queryResourceTypesToExport();
        if (newSelectedTypes != null) {
            this.selectedTypes = new ArrayList(newSelectedTypes.length);
            int i = 0;
            while (i < newSelectedTypes.length) {
                this.selectedTypes.add(newSelectedTypes[i]);
                ++i;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected boolean hasExportableExtension(String resourceName) {
        if (this.selectedTypes == null) {
            return true;
        }
        int separatorIndex = resourceName.lastIndexOf(".");
        if (separatorIndex == -1) {
            return false;
        }
        String extension = resourceName.substring(separatorIndex + 1);
        Iterator it = this.selectedTypes.iterator();
        while (it.hasNext()) {
            if (!extension.equalsIgnoreCase((String)it.next())) continue;
            return true;
        }
        return false;
    }

    protected void internalSaveWidgetValues() {
    }

    protected Object[] queryResourceTypesToExport() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.getContainer().getShell(), (Collection)this.getTypesToExport());
        dialog.open();
        return dialog.getResult();
    }

    protected void restoreResourceSpecificationWidgetValues() {
    }

    @Override
    protected void saveWidgetValues() {
        this.internalSaveWidgetValues();
    }

    protected void setupBasedOnInitialSelections() {
        for (IResource currentResource : this.initialResourceSelection) {
            if (currentResource.getType() == 1) {
                this.resourceGroup.initialCheckListItem(currentResource);
                continue;
            }
            this.resourceGroup.initialCheckTreeItem(currentResource);
        }
    }

    private void setupSelectionsBasedOnSelectedTypes() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Hashtable selectionMap = new Hashtable();
                for (IResource resource : WizardExportResourcesPage.this.resourceGroup.getAllWhiteCheckedItems()) {
                    if (resource.getType() == 1) {
                        if (!WizardExportResourcesPage.this.hasExportableExtension(resource.getName())) continue;
                        List<Object> resourceList = new ArrayList<IResource>();
                        IContainer parent = resource.getParent();
                        if (selectionMap.containsKey(parent)) {
                            resourceList = (List)selectionMap.get(parent);
                        }
                        resourceList.add(resource);
                        selectionMap.put(parent, resourceList);
                        continue;
                    }
                    WizardExportResourcesPage.this.setupSelectionsBasedOnSelectedTypes(selectionMap, (IContainer)resource);
                }
                WizardExportResourcesPage.this.resourceGroup.updateSelections(selectionMap);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    private void setupSelectionsBasedOnSelectedTypes(Map selectionMap, IContainer parent) {
        IResource[] resources;
        ArrayList<IResource> selections = new ArrayList<IResource>();
        boolean hasFiles = false;
        try {
            resources = parent.members();
        }
        catch (CoreException coreException) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                if (this.hasExportableExtension(resource.getName())) {
                    hasFiles = true;
                    selections.add(resource);
                }
            } else {
                this.setupSelectionsBasedOnSelectedTypes(selectionMap, (IContainer)resource);
            }
            ++i;
        }
        if (hasFiles) {
            selectionMap.put(parent, selections);
        }
    }

    protected boolean saveDirtyEditors() {
        return IDEWorkbenchPlugin.getDefault().getWorkbench().saveAllEditors(true);
    }

    @Override
    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }
}

