/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.IStatusContextViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class TextStatusContextViewer
implements IStatusContextViewer {
    private SourceViewer fSourceViewer;
    private ViewForm fForm;
    private CLabel fLabel;
    private Image fPaneImage;
    static /* synthetic */ Class class$0;

    protected SourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected abstract SourceViewer createSourceViewer(Composite var1);

    protected void updateTitle(IAdaptable element) {
        String title = null;
        ImageDescriptor imageDescriptor = null;
        if (element != null) {
            IWorkbenchAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
                title = adapter.getLabel((Object)element);
                imageDescriptor = adapter.getImageDescriptor((Object)element);
            }
        }
        if (title == null || title.length() == 0) {
            title = RefactoringUIMessages.RefactoringStatusViewer_Problem_context;
        }
        this.fLabel.setText(title);
        if (this.fPaneImage != null) {
            this.fPaneImage.dispose();
            this.fPaneImage = null;
        }
        if (imageDescriptor != null) {
            this.fPaneImage = imageDescriptor.createImage((Device)this.getControl().getDisplay());
        }
        this.fLabel.setImage(this.fPaneImage);
    }

    protected void setInput(IDocument document, IRegion region) {
        Control ctrl = this.getControl();
        if (ctrl != null && ctrl.isDisposed()) {
            ctrl = null;
        }
        try {
            if (ctrl != null) {
                ctrl.setRedraw(false);
            }
            this.fSourceViewer.setInput((Object)document);
            if (region != null && document != null) {
                int offset = region.getOffset();
                int length = region.getLength();
                if (offset >= 0 && length >= 0) {
                    this.fSourceViewer.setSelectedRange(offset, length);
                    this.fSourceViewer.revealRange(offset, length);
                }
            }
        }
        finally {
            if (ctrl != null) {
                ctrl.setRedraw(true);
            }
        }
    }

    public void createControl(Composite parent) {
        this.fForm = new ViewForm(parent, 0x800800);
        this.fForm.marginWidth = 0;
        this.fForm.marginHeight = 0;
        this.fLabel = new CLabel((Composite)this.fForm, 0);
        this.fForm.setTopLeft((Control)this.fLabel);
        this.fForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TextStatusContextViewer.this.fPaneImage != null) {
                    TextStatusContextViewer.this.fPaneImage.dispose();
                }
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.fSourceViewer = this.createSourceViewer((Composite)this.fForm);
        this.fSourceViewer.setEditable(false);
        this.fForm.setContent(this.fSourceViewer.getControl());
    }

    public Control getControl() {
        return this.fForm;
    }
}

