/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.variants.IResourceVariant;

public abstract class AbstractGitResourceVariant
implements IResourceVariant {
    protected final Repository repository;
    protected final String path;
    protected final boolean isContainer;
    protected final ObjectId objectId;
    protected final int rawMode;

    protected AbstractGitResourceVariant(Repository repository, String path, boolean isContainer, ObjectId objectId, int rawMode) {
        this.repository = repository;
        this.path = path;
        this.isContainer = isContainer;
        this.objectId = objectId;
        this.rawMode = rawMode;
    }

    public String getName() {
        int lastSeparator = this.path.lastIndexOf(47);
        return this.path.substring(lastSeparator + 1);
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public String getContentIdentifier() {
        return this.objectId.name();
    }

    public byte[] asBytes() {
        return this.objectId.name().getBytes();
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public int getRawMode() {
        return this.rawMode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractGitResourceVariant) {
            AbstractGitResourceVariant other = (AbstractGitResourceVariant)obj;
            return this.path.equals(other.path) && this.repository.equals(other.repository) && this.objectId.equals((AnyObjectId)other.objectId);
        }
        return false;
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 37 * hash + (this.repository != null ? this.repository.hashCode() : 0);
        hash = 37 * hash + (this.objectId != null ? this.objectId.hashCode() : 0);
        return hash;
    }
}

