/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.java7;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.NativeHandler;

public class DosHandler
extends NativeHandler {
    private static final int ATTRIBUTES = 122;

    public FileInfo fetchFileInfo(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        boolean exists = Files.exists(path, LinkOption.NOFOLLOW_LINKS);
        FileInfo info = new FileInfo();
        info.setExists(exists);
        boolean isSymbolicLink = Files.isSymbolicLink(path);
        if (isSymbolicLink) {
            info.setAttribute(32, true);
            try {
                info.setStringAttribute(64, Files.readSymbolicLink(path).toString());
            }
            catch (IOException iOException) {
                info.setError(5);
            }
        }
        if (!exists) {
            return info;
        }
        try {
            String canonicalName = new File(fileName).getCanonicalFile().getName();
            info.setName(canonicalName);
            DosFileAttributes attrs = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            info.setLastModified(attrs.lastModifiedTime().toMillis());
            info.setLength(attrs.size());
            info.setDirectory(Files.isDirectory(path, new LinkOption[0]));
            info.setAttribute(8, attrs.isArchive());
            info.setAttribute(2, attrs.isReadOnly());
            info.setAttribute(16, attrs.isHidden());
        }
        catch (IOException iOException) {
            info.setError(5);
        }
        return info;
    }

    public int getSupportedAttributes() {
        return 122;
    }

    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        Path path = Paths.get(fileName, new String[0]);
        DosFileAttributeView view = Files.getFileAttributeView(path, DosFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            view.setArchive(info.getAttribute(8));
            view.setReadOnly(info.getAttribute(2));
            view.setHidden(info.getAttribute(16));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

