/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.LogFactory;
import org.eclipse.rcptt.verifications.log.tools.ErrorLogUtil;
import org.eclipse.rcptt.verifications.runtime.ErrorList;

public class ErrorLogVerificationProcessor
extends VerificationProcessor
implements ILogListener {
    private final Set<LogEntryPredicate> whiteList = new HashSet<LogEntryPredicate>();
    private final List<IStatus> testLog = new ArrayList<IStatus>();
    private final State STARTED = new State(this){

        @Override
        State onFinish() {
            return FINISHED;
        }

        @Override
        State onRun() {
            return RUNNING;
        }
    };
    private final State FINISHED = new State(this){

        @Override
        State onStart() {
            this.reset();
            return STARTED;
        }
    };
    private final State RUNNING = new State(this){

        @Override
        State onStart() {
            this.reset();
            return STARTED;
        }

        @Override
        State onFinish() {
            return FINISHED;
        }
    };
    private State currentState = this.FINISHED;

    private void reset() {
        this.whiteList.clear();
        this.testLog.clear();
    }

    public ErrorLogVerificationProcessor() {
        Platform.addLogListener((ILogListener)this);
    }

    public synchronized Object start(Verification verification, IProcess process) throws CoreException {
        this.currentState = this.currentState.onStart();
        ErrorLogVerification logVer = (ErrorLogVerification)verification;
        this.whiteList.addAll((Collection<LogEntryPredicate>)logVer.getAllowed());
        this.whiteList.addAll((Collection<LogEntryPredicate>)logVer.getRequired());
        return null;
    }

    public synchronized Object run(Verification verification, Object data, IProcess process) throws CoreException {
        this.currentState = this.currentState.onFinish();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        IProcess iProcess = process;
        synchronized (iProcess) {
            this.currentState = this.currentState.onFinish();
        }
        final ErrorLogVerification logVerification = (ErrorLogVerification)verification;
        ErrorList errors = (ErrorList)UIRunnable.exec((UIRunnable)new UIRunnable<ErrorList>(){

            public ErrorList run() throws CoreException {
                return ErrorLogVerificationProcessor.this.findErrors(logVerification);
            }
        });
        errors.throwIfAny(String.format("Error log verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    private ErrorList findErrors(ErrorLogVerification logVerification) {
        ErrorList errors = new ErrorList();
        for (IStatus status : this.testLog) {
            LogEntryPredicate denied;
            if (this.isWhiteListed(status) || (denied = ErrorLogUtil.find((Collection)logVerification.getDenied(), (IStatus)status)) == null) continue;
            errors.add("Log entry\n%s\nis denied by predicate\n%s", new Object[]{ErrorLogUtil.describe((IStatus)status), ErrorLogUtil.describe((LogEntryPredicate)denied)});
        }
        for (LogEntryPredicate predicate : logVerification.getRequired()) {
            if (ErrorLogUtil.find(this.testLog, (LogEntryPredicate)predicate) != null) continue;
            errors.add("Required \n%s\nnot found", new Object[]{ErrorLogUtil.describe((LogEntryPredicate)predicate)});
        }
        return errors;
    }

    public synchronized void logging(IStatus status, String plugin) {
        this.testLog.add(status);
    }

    private boolean isWhiteListed(IStatus status) {
        LogEntryPredicate rv = ErrorLogUtil.find(this.whiteList, (IStatus)status);
        if (rv != null) {
            ErrorLogVerification verification = (ErrorLogVerification)rv.eContainer();
            ReportManager.appendLog((String)String.format("Log entry %s is allowed by verification %s with %s", ErrorLogUtil.describe((IStatus)status), verification.getName(), ErrorLogUtil.describe((LogEntryPredicate)rv)));
        }
        return rv != null;
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        ErrorLogVerification rv = LogFactory.eINSTANCE.createErrorLogVerification();
        for (IStatus entry : this.testLog) {
            rv.getAllowed().add((Object)ErrorLogUtil.createMatchingPredicate((IStatus)entry));
        }
        return rv;
    }

    class State {
        State() {
        }

        State onStart() {
            return this;
        }

        State onRun() {
            return this;
        }

        State onFinish() {
            return this;
        }
    }
}

