/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;

public class R4EUIMeetingData
implements IMeetingData {
    private final R4EMeetingData fMeetingData;
    private final Persistence.ResourceUpdater fResUpdater = R4EUIModelController.FResourceUpdater;

    public R4EUIMeetingData(R4EMeetingData aMeetingData) {
        this.fMeetingData = aMeetingData;
    }

    public int getSentCounter() {
        return this.fMeetingData.getSentCount();
    }

    public void incrementSentCounter() {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setSentCount(this.fMeetingData.getSentCount() + 1);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public void clearSentCounter() {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setSentCount(0);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String getCustomID() {
        return this.fMeetingData.getId();
    }

    public void setCustomID(String aId) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setId(aId);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String getSubject() {
        return this.fMeetingData.getSubject();
    }

    public void setSubject(String aSubject) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setSubject(aSubject);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String getBody() {
        return this.fMeetingData.getBody();
    }

    public void setBody(String aBody) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setBody(aBody);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String getLocation() {
        return this.fMeetingData.getLocation();
    }

    public void setLocation(String aLocation) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setLocation(aLocation);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public Long getStartTime() {
        return this.fMeetingData.getStartTime() + R4EUIConstants.TIME_ZONE_OFFSET;
    }

    public void setStartTime(Long aStartTime) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setStartTime(aStartTime.longValue());
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public Integer getDuration() {
        return this.fMeetingData.getDuration();
    }

    public void setDuration(Integer aDuration) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setDuration(aDuration.intValue());
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String getSender() {
        return this.fMeetingData.getSender();
    }

    public void setSender(String aSender) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.setSender(aSender);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public String[] getReceivers() {
        EList receiversRaw = this.fMeetingData.getReceivers();
        ArrayList<String> receiversFiltered = new ArrayList<String>();
        for (String entry : receiversRaw) {
            if (entry == null || entry.trim().equals("")) continue;
            receiversFiltered.add(entry);
        }
        String[] receivers = receiversFiltered.toArray(new String[receiversFiltered.size()]);
        return receivers;
    }

    public void clearReceivers() {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.getReceivers().clear();
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public void addReceiver(String aReceiver) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.getReceivers().add((Object)aReceiver);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public void removeReceiver(String aReceiver) {
        try {
            Long bookNum = this.fResUpdater.checkOut((EObject)this.fMeetingData, R4EUIModelController.getReviewer());
            this.fMeetingData.getReceivers().remove((Object)aReceiver);
            this.fResUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
    }

    public boolean equals(IMeetingData aData) {
        return aData != null && this.getLocation().equals(aData.getLocation()) && this.getDuration().intValue() == aData.getDuration().intValue() && this.getStartTime().longValue() == aData.getStartTime().longValue();
    }
}

