/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.util.Date;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

public class AnomalyUtils {
    private static final String[] WARNING_BUTTONS_LABELS = new String[]{"Continue", "Cancel"};
    private static final String VERSION_STR = "Version: ";
    private static final String QUESTION_TITLE = "R4E question";
    private static final String WORKSPACE_FILE_STR = "Workspace file: ";
    private static final String FILE_VERSION_STR = "Selected file version to review: ";
    private static final String QUESTION_STR = "Are you sure you want to add this anomaly to the workspace file ?";
    private static final String MESSAGE_STR = "You are adding an anomaly to a file version which is different from the one selected for review.";

    public static void addAnomalyFromText(ITextSelection aSelection, IEditorInput aInput, boolean aClone) {
        try {
            R4EUITextPosition position = CommandUtils.getPosition(aSelection);
            R4EFileVersion baseVersion = CommandUtils.getBaseFileData(aInput);
            R4EFileVersion targetVersion = CommandUtils.getTargetFileData(aInput);
            if (targetVersion != null) {
                AnomalyUtils.addAnomaly(baseVersion, targetVersion, position, aClone);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Anomaly Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Anomaly", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    public static void addAnomalyFromTree(Object aSelection, IProgressMonitor aMonitor, boolean aClone) {
        try {
            R4EUITextPosition position = null;
            IFile workspaceFile = null;
            if (aSelection instanceof IFile) {
                position = CommandUtils.getPosition((IFile)aSelection);
                workspaceFile = (IFile)aSelection;
            } else if (R4EUIPlugin.isJDTAvailable() && aSelection instanceof org.eclipse.jdt.core.ISourceReference) {
                workspaceFile = (IFile)((IJavaElement)aSelection).getResource();
                position = CommandUtils.getPosition((org.eclipse.jdt.core.ISourceReference)aSelection, workspaceFile);
            } else if (R4EUIPlugin.isCDTAvailable() && aSelection instanceof ISourceReference) {
                if (aSelection instanceof ITranslationUnit) {
                    workspaceFile = (IFile)((ICElement)aSelection).getResource();
                } else if (aSelection instanceof ICElement) {
                    workspaceFile = (IFile)((ICElement)aSelection).getParent().getResource();
                } else {
                    R4EUIPlugin.Ftracer.traceWarning("Invalid selection " + aSelection.getClass().toString() + ".  Ignoring");
                    return;
                }
                position = CommandUtils.getPosition((ISourceReference)aSelection, workspaceFile);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Invalid selection " + aSelection.getClass().toString() + ".  Ignoring");
                return;
            }
            R4EFileVersion baseVersion = CommandUtils.updateBaseFile(workspaceFile);
            R4EFileVersion targetVersion = CommandUtils.updateTargetFile(workspaceFile);
            if (targetVersion != null) {
                aMonitor.subTask("Adding " + targetVersion.getName());
                AnomalyUtils.addAnomaly(baseVersion, targetVersion, position, aClone);
                aMonitor.worked(1);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Anomaly Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Anomaly", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    public static void addAnomaly(R4EFileVersion aBaseFileVersion, final R4EFileVersion aTargetFileVersion, IR4EUIPosition aUIPosition, boolean aClone) {
        R4EUIFileContext tempFileContext = null;
        List<R4EUIReviewItem> reviewItems = R4EUIModelController.getActiveReview().getReviewItems();
        Date date1 = null;
        Date datelatest = null;
        R4EUIAnomalyContainer anomalyContainer = null;
        Object file = null;
        for (R4EUIReviewItem reviewItem : reviewItems) {
            R4EUIFileContext[] files;
            R4EUIFileContext[] r4EUIFileContextArray = files = (R4EUIFileContext[])reviewItem.getChildren();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIFileContext selectedFile = r4EUIFileContextArray[n2];
                if (selectedFile.getFileContext().getTarget() != null && aTargetFileVersion.getLocalVersionID().equals(selectedFile.getFileContext().getTarget().getLocalVersionID())) {
                    if (file == null && selectedFile.getAnomalyContainerElement() != null) {
                        file = selectedFile;
                        datelatest = reviewItem.getItem().getSubmitted();
                    }
                    if ((date1 = reviewItem.getItem().getSubmitted()) != null && (datelatest == null || datelatest.before(date1))) {
                        datelatest = date1;
                        file = selectedFile;
                    }
                }
                ++n2;
            }
        }
        if (file != null) {
            anomalyContainer = ((R4EUIFileContext)file).getAnomalyContainerElement();
            AnomalyUtils.addAnomalyToExistingFileContext((R4EUIFileContext)file, anomalyContainer, aUIPosition, aClone);
            R4EUIPlugin.Ftracer.traceInfo("Added anomaly: Target = " + ((R4EUIFileContext)file).getFileContext().getTarget().getName() + (((R4EUIFileContext)file).getFileContext().getBase() != null ? "Base = " + ((R4EUIFileContext)file).getFileContext().getBase().getName() : "") + " Position = " + aUIPosition.toString());
            return;
        }
        String targetPlatformURI = aTargetFileVersion.getPlatformURI();
        String targetPlatformPath = aTargetFileVersion.getRepositoryPath();
        if (targetPlatformURI != null) {
            for (R4EUIReviewItem reviewItem : reviewItems) {
                R4EUIFileContext[] files;
                R4EUIFileContext[] r4EUIFileContextArray = files = (R4EUIFileContext[])reviewItem.getChildren();
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    R4EUIFileContext searchFile = r4EUIFileContextArray[n3];
                    if (searchFile.getFileContext().getTarget() != null) {
                        String reviewPlatformURI = searchFile.getFileContext().getTarget().getPlatformURI();
                        String reviewPlatformPath = searchFile.getFileContext().getTarget().getRepositoryPath();
                        if (reviewPlatformURI != null) {
                            if (reviewPlatformURI.equals(targetPlatformURI)) {
                                tempFileContext = searchFile;
                            }
                        } else if (reviewPlatformPath != null && reviewPlatformPath.equals(targetPlatformPath)) {
                            tempFileContext = searchFile;
                        }
                    }
                    ++n3;
                }
            }
        }
        if (tempFileContext != null) {
            final int[] result = new int[1];
            final R4EUIFileContext dContext = tempFileContext;
            if (!UIUtils.TEST_MODE) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog dialog = AnomalyUtils.displayDifferentFileVersionDialog(aTargetFileVersion, dContext);
                        result[0] = dialog.open();
                    }
                });
            } else {
                result[0] = 0;
            }
            if (result[0] == 1) {
                return;
            }
        }
        AnomalyUtils.addAnomalyToNewFileContext(aBaseFileVersion, aTargetFileVersion, aUIPosition, aClone);
        R4EUIPlugin.Ftracer.traceInfo("Added Anomaly: Target = " + aTargetFileVersion.getName() + "_" + aTargetFileVersion.getVersionID() + (aBaseFileVersion != null ? "Base = " + aBaseFileVersion.getName() + "_" + aBaseFileVersion.getVersionID() : "") + " Position = " + aUIPosition.toString());
    }

    private static MessageDialog displayDifferentFileVersionDialog(R4EFileVersion aTargetFileVersion, R4EUIFileContext aTempFileContext) {
        String wsFileName = aTargetFileVersion.getRepositoryPath();
        String wsFileVersion = aTargetFileVersion.getVersionID();
        String riFileName = aTempFileContext.getTargetFileVersion().getRepositoryPath();
        String riFileVersion = aTempFileContext.getTargetFileVersion().getVersionID();
        StringBuilder sb = new StringBuilder();
        sb.append(MESSAGE_STR + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(FILE_VERSION_STR);
        sb.append(String.valueOf(riFileName) + R4EUIConstants.LINE_FEED);
        sb.append(VERSION_STR);
        sb.append(String.valueOf(riFileVersion) + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(WORKSPACE_FILE_STR);
        sb.append(String.valueOf(wsFileName) + R4EUIConstants.LINE_FEED);
        sb.append(VERSION_STR);
        sb.append(String.valueOf(wsFileVersion) + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(QUESTION_STR);
        MessageDialog dialog = new MessageDialog(null, QUESTION_TITLE, null, sb.toString(), 4, WARNING_BUTTONS_LABELS, 0);
        return dialog;
    }

    private static void addAnomalyToExistingFileContext(R4EUIFileContext aTargetFile, R4EUIAnomalyContainer aContainer, IR4EUIPosition aUIPosition, boolean aClone) {
        aContainer.createAnomaly(aTargetFile, (R4EUITextPosition)aUIPosition, aClone);
    }

    private static void addAnomalyToNewFileContext(final R4EFileVersion aBaseFileVersion, final R4EFileVersion aTargetFileVersion, final IR4EUIPosition aUIPosition, boolean aClone) {
        final R4EAnomaly tempAnomaly = R4EUIAnomalyContainer.createDetachedAnomaly(aClone);
        if (tempAnomaly != null) {
            Job job = new Job("Creating New Anomaly..."){
                public String familyName;
                {
                    super($anonymous0);
                    this.familyName = "R4EUI";
                }

                public boolean belongsTo(Object family) {
                    return this.familyName.equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
                        R4EUIReviewItem uiReviewItem = uiReview.createResourceReviewItem(aTargetFileVersion.getName());
                        if (uiReviewItem == null) {
                            return Status.CANCEL_STATUS;
                        }
                        R4EUIFileContext uiFileContext = uiReviewItem.createFileContext(aBaseFileVersion, aTargetFileVersion, null);
                        if (uiFileContext == null) {
                            uiReview.removeChildren(uiReviewItem, false);
                            return Status.CANCEL_STATUS;
                        }
                        R4EUIAnomalyContainer uiAnomalyContainer = uiFileContext.getAnomalyContainerElement();
                        R4EUIAnomalyBasic uiAnomaly = uiAnomalyContainer.createAnomalyFromDetached(aTargetFileVersion, tempAnomaly, (R4EUITextPosition)aUIPosition, false);
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(uiAnomaly, -1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    public static String isAnomalyExist(R4EUIFileContext aFile, IR4EUIPosition aNewAnomalyPosition, String aNewAnomalyDescription) {
        R4EUIAnomalyBasic[] existingAnomalies;
        R4EUIAnomalyContainer anomalyContainer = aFile.getAnomalyContainerElement();
        R4EUIAnomalyBasic[] r4EUIAnomalyBasicArray = existingAnomalies = (R4EUIAnomalyBasic[])anomalyContainer.getChildren();
        int n = existingAnomalies.length;
        int n2 = 0;
        while (n2 < n) {
            R4EUIAnomalyBasic uiAnomaly = r4EUIAnomalyBasicArray[n2];
            if (uiAnomaly.getPosition().isSameAs(aNewAnomalyPosition) && uiAnomaly.getAnomaly().getDescription().equals(aNewAnomalyDescription)) {
                return aNewAnomalyDescription;
            }
            ++n2;
        }
        return null;
    }

    public static String isCommentExist(R4EUIAnomalyBasic aAnomaly, String aNewCommentDescription) {
        IR4EUIModelElement[] existingUiComments;
        IR4EUIModelElement[] iR4EUIModelElementArray = existingUiComments = aAnomaly.getChildren();
        int n = existingUiComments.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement uiComment = iR4EUIModelElementArray[n2];
            if (((R4EUIComment)uiComment).getComment().getDescription().equals(aNewCommentDescription)) {
                return aNewCommentDescription;
            }
            ++n2;
        }
        return null;
    }

    public static void cloneLinkedAnomaly(R4EUIContent aTargetContent, R4EUIAnomalyBasic aSourceAnomaly) throws ResourceHandlingException, OutOfSyncException {
        R4EUIFileContext fileContext = (R4EUIFileContext)aTargetContent.getParent().getParent();
        R4EUIAnomalyContainer container = fileContext.getAnomalyContainerElement();
        R4EUIAnomalyBasic newUiAnomaly = container.createAnomalyFromDetached(fileContext.getTargetFileVersion(), aSourceAnomaly.getAnomaly(), (R4EUITextPosition)aTargetContent.getPosition(), true);
        UIUtils.setNavigatorViewFocus(newUiAnomaly, -1);
    }
}

