/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleSetInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RuleSetInputDialog
extends FormDialog
implements IRuleSetInputDialog {
    private static final String ADD_RULE_SET_DIALOG_TITLE = "Enter Rule Set Details";
    private static final String ADD_RULE_SET_VERSION_DIALOG_VALUE = "Version:";
    private static final String ADD_RULE_SET_NAME_DIALOG_VALUE = "Name:";
    private static final String ADD_RULE_SET_FOLDER_DIALOG_VALUE = "Folder:";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this Rule Set";
    private String fVersionValue = "";
    private Text fVersionInputTextField;
    private String fFolderValue = "";
    private Text fFolderInputTextField = null;
    private String fNameValue = "";
    private Text fNameInputTextField = null;
    private final IInputValidator fValidator;

    public RuleSetInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fVersionInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Rule Set Version", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fVersionValue = this.fVersionInputTextField.getText().trim();
            validateResult = this.validateFolderInput(this.fFolderInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Invalid input folder", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            validateResult = this.validateFileExists(String.valueOf(this.fFolderInputTextField.getText()) + System.getProperty("file.separator") + this.fNameInputTextField.getText() + "_rule_set.xrer");
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Rule Set file already exists", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fFolderValue = this.fFolderInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fNameInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Rule Set Name", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fNameValue = this.fNameInputTextField.getText().trim();
        } else {
            this.fVersionValue = null;
            this.fFolderValue = null;
            this.fNameValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_RULE_SET_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RuleSetInputDialog.this.getShell().setSize(RuleSetInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, ADD_RULE_SET_VERSION_DIALOG_VALUE);
        label.setToolTipText("The Version for this Rule Set");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fVersionInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fVersionInputTextField.setToolTipText("The Version for this Rule Set");
        this.fVersionInputTextField.setLayoutData((Object)textGridData);
        this.fVersionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleSetInputDialog.this.fVersionInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fNameInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fFolderInputTextField.getText().length() > 0) {
                    RuleSetInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleSetInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_SET_NAME_DIALOG_VALUE);
        label.setToolTipText("A Name that Identifies this Rule Set.A Rule Set is a Collection of Related Design Rules bundled together");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fNameInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fNameInputTextField.setToolTipText("A Name that Identifies this Rule Set.A Rule Set is a Collection of Related Design Rules bundled together");
        this.fNameInputTextField.setLayoutData((Object)textGridData);
        this.fNameInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleSetInputDialog.this.fVersionInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fNameInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fFolderInputTextField.getText().length() > 0) {
                    RuleSetInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleSetInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_RULE_SET_FOLDER_DIALOG_VALUE);
        label.setToolTipText("The Location (Folder) where the Rule Set Information is Stored.  Rule Set Information is stored in files that have a _rule_set.xrer suffix");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fFolderInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        GridData folderTextData = new GridData(4, 1, true, false);
        folderTextData.horizontalSpan = 2;
        this.fFolderInputTextField.setToolTipText("The Location (Folder) where the Rule Set Information is Stored.  Rule Set Information is stored in files that have a _rule_set.xrer suffix");
        this.fFolderInputTextField.setLayoutData((Object)folderTextData);
        Button folderButton = toolkit.createButton(basicSectionClient, "", 0);
        folderButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage());
        textGridData = new GridData(1, 1, false, false);
        textGridData.horizontalSpan = 1;
        folderButton.setToolTipText("Browse Folders...");
        folderButton.setLayoutData((Object)textGridData);
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String result = RuleSetInputDialog.this.folderButtonPressed();
                if (result == null) {
                    RuleSetInputDialog.this.fFolderInputTextField.setText("");
                } else {
                    RuleSetInputDialog.this.fFolderInputTextField.setText(result);
                }
            }
        });
        this.fFolderInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RuleSetInputDialog.this.fVersionInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fNameInputTextField.getText().length() > 0 && RuleSetInputDialog.this.fFolderInputTextField.getText().length() > 0) {
                    RuleSetInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    RuleSetInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.fVersionInputTextField.setFocus();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected String folderButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setMessage("Select Folder...");
        String dir = dialog.open();
        if (dir != null && (dir = dir.trim()).length() == 0) {
            return null;
        }
        return dir;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getVersionValue() {
        return this.fVersionValue;
    }

    public String getFolderValue() {
        return this.fFolderValue;
    }

    public String getNameValue() {
        return this.fNameValue;
    }

    protected String validateFolderInput(Text aText) {
        return ((R4EInputValidator)this.fValidator).isFolderValid(aText.getText());
    }

    private String validateFileExists(String aFilePath) {
        return ((R4EInputValidator)this.fValidator).isFileExists(aFilePath);
    }

    private String validateEmptyInput(Text aText) {
        if (this.fValidator != null) {
            return this.fValidator.isValid(aText.getText());
        }
        return null;
    }
}

