/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.equinox.requirements.BundleName;
import org.eclipse.passage.lic.equinox.requirements.RequirementFromAttributes;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;

final class RequirementFromCapability
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Bundle bundle;
    private final BundleCapability capability;

    public RequirementFromCapability(Bundle bundle, BundleCapability capability) {
        this.bundle = bundle;
        this.capability = capability;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        Optional<Map> attributes = Optional.ofNullable(this.capability.getAttributes());
        if (!attributes.isPresent()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), NLS.bind((String)EquinoxMessages.RequirementsFromCapability_no_attributes, (Object)this.capability.getNamespace(), (Object)new BundleName(this.bundle).get())));
        }
        return new RequirementFromAttributes(this.bundle, attributes.get()).get();
    }
}

