/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.lic.users.model.util.UsersResourceImpl;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.api.workspace.Users;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.internal.users.core.UsersDomainRegistryTracker;
import org.eclipse.passage.loc.internal.users.core.i18n.UsersCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=users", "org.eclipse.passage.lic.emf.edit.file.extension=users_xmi"})
public class UserDomainRegistry
extends BaseDomainRegistry<UserOriginDescriptor>
implements UserRegistry,
EditingDomainRegistry<UserOriginDescriptor> {
    private final Map<String, UserOriginDescriptor> userOriginIndex = new HashMap<String, UserOriginDescriptor>();
    private final Map<String, UserDescriptor> userIndex = new HashMap<String, UserDescriptor>();
    private EventAdmin events;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.userIndex.clear();
        this.userOriginIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "users_xmi";
    }

    public Class<UserOriginDescriptor> getContentClass() {
        return UserOriginDescriptor.class;
    }

    public String resolveIdentifier(UserOriginDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<UserOriginDescriptor> getUserOrigins() {
        return new ArrayList<UserOriginDescriptor>(this.userOriginIndex.values());
    }

    @Override
    public UserOriginDescriptor getUserOrigin(String identifier) {
        return this.userOriginIndex.get(identifier);
    }

    @Override
    public Iterable<? extends UserDescriptor> getUsers() {
        return new ArrayList<UserDescriptor>(this.userIndex.values());
    }

    public Iterable<? extends UserDescriptor> getUsers(String userOriginId) {
        UserOriginDescriptor userOrigin = this.userOriginIndex.get(userOriginId);
        if (userOrigin == null) {
            return Collections.emptyList();
        }
        return userOrigin.getUsers();
    }

    @Override
    public UserDescriptor getUser(String identifier) {
        return this.userIndex.get(identifier);
    }

    protected DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> createContentAdapter() {
        return new UsersDomainRegistryTracker(this);
    }

    public void registerUserOrigin(UserOriginDescriptor userOrigin) {
        String identifier = userOrigin.getIdentifier();
        UserOriginDescriptor existing = this.userOriginIndex.put(identifier, userOrigin);
        if (existing != null) {
            String msg = NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)userOrigin);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/create", (Object)userOrigin).get());
        userOrigin.getUsers().forEach(u -> this.registerUser((UserDescriptor)u));
    }

    public void registerUser(UserDescriptor user) {
        String identifier = user.getContact().getEmail();
        UserDescriptor existing = this.userIndex.put(identifier, user);
        if (existing != null) {
            String msg = NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)user);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/create", (Object)user).get());
    }

    public void unregisterUserOrigin(String userOriginId) {
        UserOriginDescriptor removed = this.userOriginIndex.remove(userOriginId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/delete", (Object)removed).get());
            removed.getUsers().forEach(u -> this.unregisterUser(u.getContact().getEmail()));
        }
    }

    public void unregisterUser(String userId) {
        UserDescriptor removed = this.userIndex.remove(userId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/delete", (Object)removed).get());
        }
    }

    public EClass getContentClassifier() {
        return UsersPackage.eINSTANCE.getUserOrigin();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Name();
    }

    public void registerContent(UserOriginDescriptor content) {
        this.registerUserOrigin(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterUserOrigin(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new UsersResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Users.xmi.equals(handle.type()) || Users.xmi033.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.users();
    }
}

