/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.FloatingLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.loc.yars.internal.api.DosHandleMedia;
import org.eclipse.passage.loc.yars.internal.api.ExportData;
import org.eclipse.passage.loc.yars.internal.api.Progress;

public final class LicensePlanReport
implements ExportData<LicensePlanReport, DosHandleMedia<LicensePlanReport>> {
    private final LicensePlanDescriptor plan;
    private final Map<String, List<PersonalLicensePackDescriptor>> personal;
    private final Map<String, List<FloatingLicensePackDescriptor>> floating;
    private final boolean explain;
    private final SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd");

    LicensePlanReport(LicensePlanDescriptor plan, Map<String, List<PersonalLicensePackDescriptor>> personal, Map<String, List<FloatingLicensePackDescriptor>> floating, boolean explain) {
        this.plan = plan;
        this.personal = personal;
        this.floating = floating;
        this.explain = explain;
    }

    public void write(DosHandleMedia<LicensePlanReport> media, Progress<LicensePlanReport> progress) {
        media.inner(this.plan.getName(), "plan-name");
        media.inner(this.plan.getIdentifier(), "plan-id");
        media.inner(Long.toString(this.count(this.personal)), "personal");
        media.inner(Long.toString(this.count(this.floating)), "floating");
        if (this.explain) {
            media.inner(this.personal.keySet().stream().map(this::user).collect(Collectors.joining(",")), "users");
            media.inner(this.floating.keySet().stream().map(this::company).collect(Collectors.joining(",")), "companies");
        }
    }

    private String user(String user) {
        return this.info(user, this.personal, pack -> pack.getLicense().getIssueDate());
    }

    private String company(String company) {
        return this.info(company, this.floating, pack -> pack.getLicense().getIssueDate());
    }

    private <T> String info(String id, Map<String, List<T>> data, Function<T, Date> issue) {
        Object[] objectArray = new Object[2];
        objectArray[0] = id;
        objectArray[1] = data.get(id).stream().map(issue).map(this.format::format).collect(Collectors.joining(", "));
        return String.format("%s (%s)", objectArray);
    }

    private <T> long count(Map<String, List<T>> data) {
        return data.values().stream().flatMap(Collection::stream).count();
    }
}

