/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.equinox.io.InstallationPath;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.internal.users.core.UsersDomainRegistryTracker;
import org.eclipse.passage.loc.internal.users.core.i18n.UsersCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=users", "org.eclipse.passage.lic.emf.edit.file.extension=users_xmi"})
public class UserDomainRegistry
extends BaseDomainRegistry<UserOriginDescriptor>
implements UserRegistry,
EditingDomainRegistry<UserOriginDescriptor> {
    private final Map<String, UserOriginDescriptor> userOriginIndex = new HashMap<String, UserOriginDescriptor>();
    private final Map<String, UserDescriptor> userIndex = new HashMap<String, UserDescriptor>();
    private final Map<String, UserLicenseDescriptor> userLicenseIndex = new HashMap<String, UserLicenseDescriptor>();
    private EventAdmin events;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.userIndex.clear();
        this.userOriginIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "users_xmi";
    }

    public Class<UserOriginDescriptor> getContentClass() {
        return UserOriginDescriptor.class;
    }

    public String resolveIdentifier(UserOriginDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<UserOriginDescriptor> getUserOrigins() {
        return new ArrayList<UserOriginDescriptor>(this.userOriginIndex.values());
    }

    @Override
    public UserOriginDescriptor getUserOrigin(String identifier) {
        return this.userOriginIndex.get(identifier);
    }

    @Override
    public Iterable<? extends UserDescriptor> getUsers() {
        return new ArrayList<UserDescriptor>(this.userIndex.values());
    }

    public Iterable<? extends UserDescriptor> getUsers(String userOriginId) {
        UserOriginDescriptor userOrigin = this.userOriginIndex.get(userOriginId);
        if (userOrigin == null) {
            return Collections.emptyList();
        }
        return userOrigin.getUsers();
    }

    @Override
    public UserDescriptor getUser(String identifier) {
        return this.userIndex.get(identifier);
    }

    @Override
    public Iterable<? extends UserLicenseDescriptor> getUserLicenses() {
        return new ArrayList<UserLicenseDescriptor>(this.userLicenseIndex.values());
    }

    protected DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> createContentAdapter() {
        return new UsersDomainRegistryTracker(this);
    }

    public void registerUserOrigin(UserOriginDescriptor userOrigin) {
        String identifier = userOrigin.getIdentifier();
        UserOriginDescriptor existing = this.userOriginIndex.put(identifier, userOrigin);
        if (existing != null) {
            String msg = NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)userOrigin);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/create", (Object)userOrigin).get());
        userOrigin.getUsers().forEach(u -> this.registerUser((UserDescriptor)u));
    }

    public void registerUser(UserDescriptor user) {
        String identifier = user.getEmail();
        UserDescriptor existing = this.userIndex.put(identifier, user);
        if (existing != null) {
            String msg = NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)user);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/create", (Object)user).get());
        user.getUserLicenses().forEach(u -> this.registerUserLicense((UserLicenseDescriptor)u));
    }

    public void registerUserLicense(UserLicenseDescriptor userLicense) {
        String identifier = userLicense.getPackIdentifier();
        UserLicenseDescriptor existing = this.userLicenseIndex.put(identifier, userLicense);
        if (existing != null) {
            String msg = NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)userLicense);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserLicense/create", (Object)userLicense).get());
    }

    public void unregisterUserOrigin(String userOriginId) {
        UserOriginDescriptor removed = this.userOriginIndex.remove(userOriginId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/delete", (Object)removed).get());
            removed.getUsers().forEach(u -> this.unregisterUser(u.getEmail()));
        }
    }

    public void unregisterUser(String userId) {
        UserDescriptor removed = this.userIndex.remove(userId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/delete", (Object)removed).get());
        }
    }

    public void unregisterUserLicense(String packId) {
        UserLicenseDescriptor removed = this.userLicenseIndex.remove(packId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserLicense/delete", (Object)removed).get());
        }
    }

    public EClass getContentClassifier() {
        return UsersPackage.eINSTANCE.getUserOrigin();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Name();
    }

    public void registerContent(UserOriginDescriptor content) {
        this.registerUserOrigin(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterUserOrigin(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = new InstallationPath().get();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }
}

