/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.options.CreateTenantOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateTenantOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface TenantAdminAsyncApi {
    @Named(value="tenant:create")
    @POST
    @Path(value="/tenants")
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> create(@PayloadParam(value="name") String var1);

    @Named(value="tenant:create")
    @POST
    @Path(value="/tenants")
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @MapBinder(value=CreateTenantOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> create(@PayloadParam(value="name") String var1, CreateTenantOptions var2);

    @Named(value="tenant:delete")
    @DELETE
    @Path(value="/tenants/{id}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="tenant:updatetenant")
    @PUT
    @Path(value="/tenants/{id}")
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @MapBinder(value=UpdateTenantOptions.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> update(@PathParam(value="id") String var1, UpdateTenantOptions var2);

    @Named(value="tenant:addroleontenant")
    @PUT
    @Path(value="/tenants/{id}/users/{userId}/roles/OS-KSADM/{roleId}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> addRoleOnTenant(@PathParam(value="id") String var1, @PathParam(value="userId") String var2, @PathParam(value="roleId") String var3);

    @Named(value="tenant:deleteroleontenant")
    @DELETE
    @Path(value="/tenants/{id}/users/{userId}/roles/OS-KSADM/{roleId}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteRoleOnTenant(@PathParam(value="id") String var1, @PathParam(value="userId") String var2, @PathParam(value="roleId") String var3);
}

