/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;

public class Service
extends ForwardingSet<Endpoint> {
    private final String id;
    private final String type;
    private final String name;
    private final String description;
    private final Set<Endpoint> endpoints;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromService(this);
    }

    @ConstructorProperties(value={"id", "type", "name", "description", "endpoints"})
    protected Service(@Nullable String id, String type, String name, @Nullable String description, @Nullable Set<Endpoint> endpoints) {
        this.id = id;
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
        this.endpoints = endpoints == null ? ImmutableSet.of() : ImmutableSet.copyOf(endpoints);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.name, this.description, this.endpoints});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Service that = (Service)((Object)Service.class.cast(obj));
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.endpoints, that.endpoints);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("id", (Object)this.id).add("type", (Object)this.type).add("name", (Object)this.name).add("description", (Object)this.description).add("endpoints", this.endpoints);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Set<Endpoint> delegate() {
        return this.endpoints;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String type;
        protected String name;
        protected String description;
        protected ImmutableSet.Builder<Endpoint> endpoints = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T endpoint(Endpoint endpoint) {
            this.endpoints.add((Object)endpoint);
            return this.self();
        }

        public T endpoints(Iterable<Endpoint> endpoints) {
            this.endpoints.addAll(endpoints);
            return this.self();
        }

        public Service build() {
            return new Service(this.id, this.type, this.name, this.description, (Set<Endpoint>)this.endpoints.build());
        }

        public T fromService(Service in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).type(in.getType())).name(in.getName())).description(in.getDescription())).endpoints((Iterable<Endpoint>)((Object)in));
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

