/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Role {
    private final String id;
    private final String name;
    private final String description;
    private final String serviceId;
    private final String tenantId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromRole(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "serviceId", "tenantId", "tenantName"})
    protected Role(@Nullable String id, String name, @Nullable String description, @Nullable String serviceId, @Nullable String tenantId, @Nullable String tenantName) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
        this.serviceId = serviceId;
        this.tenantId = tenantId != null ? tenantId : tenantName;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.serviceId, this.tenantId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Role that = (Role)Role.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.serviceId, (Object)that.serviceId) && Objects.equal((Object)this.tenantId, (Object)that.tenantId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("serviceId", (Object)this.serviceId).add("tenantId", (Object)this.tenantId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String description;
        protected String serviceId;
        protected String tenantId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public Role build() {
            return new Role(this.id, this.name, this.description, this.serviceId, this.tenantId, null);
        }

        public T fromRole(Role in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription())).serviceId(in.getServiceId())).tenantId(in.getTenantId());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

