/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server.http2;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.server.RawHTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;

public class HTTP2ServerDocs {
    public void setup() throws Exception {
        Server server = new Server();
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter();
        RawHTTP2ServerConnectionFactory http2 = new RawHTTP2ServerConnectionFactory((ServerSessionListener)sessionListener);
        http2.setMaxConcurrentStreams(128);
        http2.setConnectProtocolEnabled(true);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http2});
        server.addConnector((Connector)connector);
        server.start();
    }

    public void accept() {
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public void onAccept(Session session) {
                SocketAddress remoteAddress = session.getRemoteSocketAddress();
                System.getLogger("http2").log(System.Logger.Level.INFO, "Connection from {0}", remoteAddress);
            }
        };
    }

    public void preface() {
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public Map<Integer, Integer> onPreface(Session session) {
                HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
                settings.put(2, 0);
                return settings;
            }
        };
    }

    public void request() {
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                return new Stream.Listener.Adapter();
            }
        };
    }

    public void requestContent() {
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                return new Stream.Listener.Adapter(){

                    public void onData(Stream stream, DataFrame frame, Callback callback) {
                        ByteBuffer buffer = frame.getData();
                        System.getLogger("http2").log(System.Logger.Level.INFO, "Consuming buffer {0}", buffer);
                        callback.succeeded();
                    }
                };
            }
        };
    }

    public void response() {
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                final MetaData.Request request = (MetaData.Request)frame.getMetaData();
                if (frame.isEndStream()) {
                    this.respond(stream, request);
                    return null;
                }
                return new Stream.Listener.Adapter(){

                    public void onData(Stream stream, DataFrame frame, Callback callback) {
                        callback.succeeded();
                        if (frame.isEndStream()) {
                            this.respond(stream, request);
                        }
                    }
                };
            }

            private void respond(Stream stream, MetaData.Request request) {
                MetaData.Response response = new MetaData.Response(HttpVersion.HTTP_2, 200, HttpFields.EMPTY);
                if (HttpMethod.GET.is(request.getMethod())) {
                    ByteBuffer resourceBytes = this.getResourceBytes(request);
                    stream.headers(new HeadersFrame(stream.getId(), (MetaData)response, null, false)).thenCompose(s -> s.data(new DataFrame(s.getId(), resourceBytes, true)));
                } else {
                    stream.headers(new HeadersFrame(stream.getId(), (MetaData)response, null, true));
                }
            }

            private ByteBuffer getResourceBytes(MetaData.Request request) {
                return ByteBuffer.allocate(1024);
            }
        };
    }

    public void reset() {
        final float maxRequestRate = 0.0f;
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){

            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                float requestRate = this.calculateRequestRate();
                if (requestRate > maxRequestRate) {
                    stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
                    return null;
                }
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                return new Stream.Listener.Adapter();
            }

            private float calculateRequestRate() {
                return 0.0f;
            }
        };
    }

    public void push() throws Exception {
        final ByteBuffer faviconBuffer = BufferUtil.toBuffer((Resource)Resource.newResource((String)"/path/to/favicon.ico"), (boolean)true);
        ServerSessionListener.Adapter sessionListener = new ServerSessionListener.Adapter(){
            private boolean pushEnabled = true;

            public void onSettings(Session session, SettingsFrame frame) {
                Map settings = frame.getSettings();
                Integer enablePush = (Integer)settings.get(2);
                if (enablePush != null) {
                    this.pushEnabled = enablePush == 1;
                }
            }

            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                if (this.pushEnabled && request.getURIString().endsWith("/index.html")) {
                    HttpURI.Mutable pushedURI = HttpURI.build((HttpURI)request.getURI()).path("/favicon.ico");
                    MetaData.Request pushedRequest = new MetaData.Request("GET", (HttpURI)pushedURI, HttpVersion.HTTP_2, HttpFields.EMPTY);
                    PushPromiseFrame promiseFrame = new PushPromiseFrame(stream.getId(), 0, pushedRequest);
                    stream.push(promiseFrame, (Stream.Listener)new Stream.Listener.Adapter()).thenCompose(pushedStream -> {
                        MetaData.Response pushedResponse = new MetaData.Response(HttpVersion.HTTP_2, 200, HttpFields.EMPTY);
                        return pushedStream.headers(new HeadersFrame(pushedStream.getId(), (MetaData)pushedResponse, null, false)).thenCompose(pushed -> pushed.data(new DataFrame(pushed.getId(), faviconBuffer, true)));
                    });
                }
                return new Stream.Listener.Adapter();
            }
        };
    }
}

