/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server.http;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerConnector;
import org.eclipse.jetty.rewrite.handler.CompactPathRule;
import org.eclipse.jetty.rewrite.handler.RedirectRegexRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.unixdomain.server.UnixDomainServerConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class HTTPServerDocs {
    public void simple() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("server");
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
                jettyRequest.setHandled(true);
            }
        });
        server.start();
    }

    public void httpChannelListener() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        class TimingHttpChannelListener
        implements HttpChannel.Listener {
            private final ConcurrentMap<Request, Long> times = new ConcurrentHashMap<Request, Long>();

            TimingHttpChannelListener() {
            }

            public void onRequestBegin(Request request) {
                this.times.put(request, NanoTime.now());
            }

            public void onComplete(Request request) {
                long begin = (Long)this.times.remove(request);
                long elapsed = NanoTime.since((long)begin);
                System.getLogger("timing").log(System.Logger.Level.INFO, "Request {0} took {1} ns", request, elapsed);
            }
        }
        connector.addBean((Object)new TimingHttpChannelListener());
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
                jettyRequest.setHandled(true);
            }
        });
        server.start();
    }

    public void serverRequestLogSLF4J() {
        Server server = new Server();
        server.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)new Slf4jRequestLogWriter(), "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\""));
    }

    public void serverRequestLogFile() {
        Server server = new Server();
        RequestLogWriter logWriter = new RequestLogWriter("/var/log/yyyy_MM_dd.jetty.request.log");
        logWriter.setRetainDays(14);
        logWriter.setTimeZone(TimeZone.getDefault().getID());
        server.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)logWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\""));
    }

    public void contextRequestLog() {
        Server server = new Server();
        ServletContextHandler mainContext = new ServletContextHandler();
        mainContext.setContextPath("/main");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new CustomRequestLog());
        requestLogHandler.setHandler((Handler)mainContext);
        ServletContextHandler otherContext = new ServletContextHandler();
        mainContext.setContextPath("/other");
        server.setHandler((Handler)new HandlerList(new Handler[]{requestLogHandler, otherContext}));
    }

    public void configureConnector() throws Exception {
        Server server = new Server();
        int acceptors = 1;
        int selectors = 1;
        ServerConnector connector = new ServerConnector(server, acceptors, selectors, new ConnectionFactory[]{new HttpConnectionFactory()});
        connector.setPort(8080);
        connector.setHost("127.0.0.1");
        connector.setAcceptQueueSize(128);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void configureConnectorUnix() throws Exception {
        Server server = new Server();
        int acceptors = 1;
        int selectors = 1;
        UnixDomainServerConnector connector = new UnixDomainServerConnector(server, acceptors, selectors, new ConnectionFactory[]{new HttpConnectionFactory()});
        connector.setUnixDomainPath(Path.of("/tmp/jetty.sock", new String[0]));
        connector.setAcceptQueueSize(128);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void configureConnectors() throws Exception {
        Server server = new Server();
        ServerConnector connector1 = new ServerConnector(server, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()});
        connector1.setPort(8080);
        server.addConnector((Connector)connector1);
        HttpConfiguration httpConfig2 = new HttpConfiguration();
        httpConfig2.setHttpCompliance(HttpCompliance.LEGACY);
        ServerConnector connector2 = new ServerConnector(server, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig2)});
        connector2.setPort(9090);
        server.addConnector((Connector)connector2);
        server.start();
    }

    public void http11() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http11});
        connector.setPort(8080);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void proxyHTTP() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http11.getProtocol());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{proxy, http11});
        connector.setPort(8080);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void proxyHTTPUnix() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http11.getProtocol());
        UnixDomainServerConnector connector = new UnixDomainServerConnector(server, new ConnectionFactory[]{proxy, http11});
        connector.setUnixDomainPath(Path.of("/tmp/jetty.sock", new String[0]));
        server.addConnector((Connector)connector);
        server.start();
    }

    public void tlsHttp11() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{tls, http11});
        connector.setPort(8443);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void http11H2C() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        HTTP2CServerConnectionFactory h2c = new HTTP2CServerConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http11, h2c});
        connector.setPort(8080);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void tlsALPNHTTP() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(http11.getProtocol());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{tls, alpn, h2, http11});
        connector.setPort(8443);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void h3() throws Exception {
        Server server = new Server();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTP3ServerConnector connector = new HTTP3ServerConnector(server, sslContextFactory, new ConnectionFactory[]{new HTTP3ServerConnectionFactory(httpConfig)});
        connector.setPort(843);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void conscrypt() {
        Security.addProvider((Provider)new OpenSSLProvider());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        sslContextFactory.setProvider("Conscrypt");
    }

    public void handlerTree() {
        Server server = new Server();
        HandlerCollection collection = new HandlerCollection();
        server.setHandler((Handler)collection);
        HandlerList list = new HandlerList();
        collection.addHandler((Handler)list);
        class LoggingHandler
        extends AbstractHandler {
            LoggingHandler() {
            }

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
            }
        }
        collection.addHandler((Handler)new LoggingHandler());
        class App1Handler
        extends AbstractHandler {
            App1Handler() {
            }

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
            }
        }
        list.addHandler((Handler)new App1Handler());
        HandlerWrapper wrapper = new HandlerWrapper();
        list.addHandler((Handler)wrapper);
        class App2Handler
        extends HandlerWrapper {
            App2Handler() {
            }

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
            }
        }
        wrapper.setHandler((Handler)new App2Handler());
    }

    public void handlerAPI() {
    }

    public void handlerHello() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        class HelloWorldHandler
        extends AbstractHandler {
            HelloWorldHandler() {
            }

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                jettyRequest.setHandled(true);
                response.setStatus(200);
                response.setContentType("text/html; charset=UTF-8");
                response.getWriter().print("<!DOCTYPE html><html><head>  <title>Jetty Hello World Handler</title></head><body>  <p>Hello World</p></body></html>");
            }
        }
        server.setHandler((Handler)new HelloWorldHandler());
        server.start();
    }

    public void handlerFilter() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        class FilterHandler
        extends HandlerWrapper {
            FilterHandler() {
            }

            public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                String path = request.getRequestURI();
                if (path.startsWith("/old_path/")) {
                    HttpURI uri = jettyRequest.getHttpURI();
                    String newPath = "/new_path/" + path.substring("/old_path/".length());
                    HttpURI.Mutable newURI = HttpURI.build((HttpURI)uri).path(newPath);
                    jettyRequest.setHttpURI((HttpURI)newURI);
                }
                super.handle(target, jettyRequest, request, response);
            }
        }
        FilterHandler filter = new FilterHandler();
        class HelloWorldHandler
        extends AbstractHandler {
            HelloWorldHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            }
        }
        filter.setHandler((Handler)new HelloWorldHandler());
        server.setHandler((Handler)filter);
        server.start();
    }

    public void contextHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ContextHandler context = new ContextHandler();
        context.setContextPath("/shop");
        class ShopHandler
        extends AbstractHandler {
            ShopHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        }
        context.setHandler((Handler)new ShopHandler());
        server.setHandler((Handler)context);
        server.start();
    }

    public void contextHandlerCollection() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contextCollection = new ContextHandlerCollection();
        server.setHandler((Handler)contextCollection);
        ContextHandler shopContext = new ContextHandler("/shop");
        class ShopHandler
        extends AbstractHandler {
            ShopHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        }
        shopContext.setHandler((Handler)new ShopHandler());
        contextCollection.addHandler((Handler)shopContext);
        server.start();
        ContextHandler apiContext = new ContextHandler("/api");
        class RESTHandler
        extends AbstractHandler {
            RESTHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        }
        apiContext.setHandler((Handler)new RESTHandler());
        contextCollection.deployHandler((Handler)apiContext, Callback.NOOP);
    }

    public void servletContextHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/shop");
        class ShopCartServlet
        extends HttpServlet {
            ShopCartServlet() {
            }

            protected void service(HttpServletRequest request, HttpServletResponse response) {
            }
        }
        ServletHolder servletHolder = context.addServlet(ShopCartServlet.class, "/cart/*");
        servletHolder.setInitParameter("maxItems", "128");
        FilterHolder filterHolder = context.addFilter(CrossOriginFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        filterHolder.setAsyncSupported(true);
        server.setHandler((Handler)context);
        server.start();
    }

    public void webAppContextHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        WebAppContext context = new WebAppContext();
        context.setWar("/path/to/webapp.war");
        context.setContextPath("/app");
        server.setHandler((Handler)context);
        server.start();
    }

    public void resourceHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ResourceHandler handler = new ResourceHandler();
        handler.setBaseResource(Resource.newResource((String)"/path/to/static/resources/"));
        handler.setDirectoriesListed(false);
        handler.setWelcomeFiles(new String[]{"index.html"});
        handler.setAcceptRanges(true);
        server.setHandler((Handler)handler);
        server.start();
    }

    public void multipleResourcesHandler() throws Exception {
        ResourceHandler handler = new ResourceHandler();
        ResourceCollection directories = new ResourceCollection();
        directories.addPath("/path/to/static/resources/");
        directories.addPath("/another/path/to/static/resources/");
        handler.setBaseResource((Resource)directories);
    }

    public void defaultServlet() {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/app");
        ServletHolder servletHolder = context.addServlet(DefaultServlet.class, "/");
        servletHolder.setInitParameter("resourceBase", "/path/to/static/resources/");
        servletHolder.setAsyncSupported(true);
    }

    public void serverGzipHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(1024);
        gzipHandler.setExcludedPaths(new String[]{"/uncompressed"});
        gzipHandler.addIncludedMethods(new String[]{"POST"});
        gzipHandler.addExcludedMimeTypes(new String[]{"font/ttf"});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        gzipHandler.setHandler((Handler)contexts);
        server.setHandler((Handler)gzipHandler);
        server.start();
    }

    public void contextGzipHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contextCollection = new ContextHandlerCollection();
        server.setHandler((Handler)contextCollection);
        ContextHandler shopContext = new ContextHandler("/shop");
        class ShopHandler
        extends AbstractHandler {
            ShopHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
            }
        }
        shopContext.setHandler((Handler)new ShopHandler());
        GzipHandler shopGzipHandler = new GzipHandler();
        shopGzipHandler.setHandler((Handler)shopContext);
        contextCollection.addHandler((Handler)shopGzipHandler);
        ContextHandler apiContext = new ContextHandler("/api");
        class RESTHandler
        extends AbstractHandler {
            RESTHandler() {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        }
        apiContext.setHandler((Handler)new RESTHandler());
        contextCollection.addHandler((Handler)apiContext);
        server.start();
    }

    public void rewriteHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.addRule((Rule)new CompactPathRule());
        rewriteHandler.addRule((Rule)new RewriteRegexRule("/(.*)/product/(.*)", "/$1/p/$2"));
        RedirectRegexRule redirectRule = new RedirectRegexRule("/documentation/(.*)", "https://docs.domain.com/$1");
        redirectRule.setStatusCode(301);
        rewriteHandler.addRule((Rule)redirectRule);
        server.setHandler((Handler)rewriteHandler);
        ContextHandlerCollection contextCollection = new ContextHandlerCollection();
        rewriteHandler.setHandler((Handler)contextCollection);
        server.start();
    }

    public void statsHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        StatisticsHandler statsHandler = new StatisticsHandler();
        server.setHandler((Handler)statsHandler);
        ContextHandlerCollection contextCollection = new ContextHandlerCollection();
        statsHandler.setHandler((Handler)contextCollection);
        server.start();
    }

    public void securedHandler() throws Exception {
        Server server = new Server();
        int securePort = 8443;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecurePort(securePort);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setPort(8080);
        server.addConnector((Connector)connector);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpsConfig);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
        ServerConnector secureConnector = new ServerConnector(server, new ConnectionFactory[]{tls, http11});
        secureConnector.setPort(8443);
        server.addConnector((Connector)secureConnector);
        SecuredRedirectHandler securedHandler = new SecuredRedirectHandler();
        server.setHandler((Handler)securedHandler);
        ContextHandlerCollection contextCollection = new ContextHandlerCollection();
        securedHandler.setHandler((Handler)contextCollection);
        server.start();
    }

    public void defaultHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        HandlerList handlerList = new HandlerList();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        handlerList.addHandler((Handler)contexts);
        DefaultHandler defaultHandler = new DefaultHandler();
        handlerList.addHandler((Handler)defaultHandler);
        server.setHandler((Handler)handlerList);
        server.start();
    }

    public void continue100() {
    }
}

