/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.client.http3;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;

public class HTTP3ClientDocs {
    public void start() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.getHTTP3Configuration().setStreamIdleTimeout(15000L);
        http3Client.start();
    }

    public void stop() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        http3Client.stop();
    }

    public void connect() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        CompletableFuture sessionCF = http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){});
        Session session = (Session)sessionCF.get();
    }

    public void configure() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){

            public Map<Long, Long> onPreface(Session session) {
                HashMap<Long, Long> configuration = new HashMap<Long, Long>();
                return configuration;
            }
        });
    }

    public void newStream() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        CompletableFuture sessionCF = http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){});
        Session.Client session = (Session.Client)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP3Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8444/path"), HttpVersion.HTTP_3, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, true);
        session.newRequest(headersFrame, new Stream.Client.Listener(){});
    }

    public void newStreamWithData() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        CompletableFuture sessionCF = http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){});
        Session.Client session = (Session.Client)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.CONTENT_TYPE, "application/json");
        MetaData.Request request = new MetaData.Request("POST", (HttpURI)HttpURI.from((String)"http://localhost:8444/path"), HttpVersion.HTTP_3, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, false);
        CompletableFuture streamCF = session.newRequest(headersFrame, new Stream.Client.Listener(){});
        Stream stream = (Stream)streamCF.get();
        String content1 = "{\"greet\": \"hello world\"}";
        ByteBuffer buffer1 = StandardCharsets.UTF_8.encode(content1);
        String content2 = "{\"user\": \"jetty\"}";
        ByteBuffer buffer2 = StandardCharsets.UTF_8.encode(content2);
        CompletableFuture dataCF1 = stream.data(new DataFrame(buffer1, false));
        dataCF1.thenCompose(s -> s.data(new DataFrame(buffer2, true)));
    }

    public void responseListener() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        CompletableFuture sessionCF = http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){});
        Session.Client session = (Session.Client)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP3Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8444/path"), HttpVersion.HTTP_3, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, true);
        session.newRequest(headersFrame, new Stream.Client.Listener(){

            public void onResponse(Stream.Client stream, HeadersFrame frame) {
                MetaData metaData = frame.getMetaData();
                MetaData.Response response = (MetaData.Response)metaData;
                System.getLogger("http3").log(System.Logger.Level.INFO, "Received response {0}", response);
            }

            public void onDataAvailable(Stream.Client stream) {
                Stream.Data data = stream.readData();
                if (data == null) {
                    stream.demand();
                } else {
                    HTTP3ClientDocs.this.process(data.getByteBuffer());
                    data.complete();
                    if (!data.isLast()) {
                        stream.demand();
                    }
                }
            }
        });
    }

    private void process(ByteBuffer byteBuffer) {
    }

    public void reset() throws Exception {
        HTTP3Client http3Client = new HTTP3Client();
        http3Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8444);
        CompletableFuture sessionCF = http3Client.connect((SocketAddress)serverAddress, new Session.Client.Listener(){});
        Session.Client session = (Session.Client)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP3Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, true);
        CompletableFuture streamCF = session.newRequest(headersFrame, new Stream.Client.Listener(){

            public void onFailure(Stream.Client stream, long error, Throwable failure) {
            }
        });
        Stream stream = (Stream)streamCF.get();
        stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), (Throwable)new ClosedChannelException());
    }
}

