/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class OverlayManager {
    private WarPluginInfo warPlugin;

    public OverlayManager(WarPluginInfo warPlugin) {
        this.warPlugin = warPlugin;
    }

    public void applyOverlays(MavenWebAppContext webApp) throws Exception {
        ArrayList<Resource> resourceBases = new ArrayList<Resource>();
        for (Overlay o : this.getOverlays()) {
            if (o.getConfig() != null && o.getConfig().isCurrentProject() && webApp.getBaseResource().exists()) {
                resourceBases.add(webApp.getBaseResource());
                continue;
            }
            resourceBases.add(this.unpackOverlay(o));
        }
        if (!resourceBases.contains(webApp.getBaseResource()) && webApp.getBaseResource().exists()) {
            if (webApp.getBaseAppFirst()) {
                resourceBases.add(0, webApp.getBaseResource());
            } else {
                resourceBases.add(webApp.getBaseResource());
            }
        }
        webApp.setBaseResource((Resource)new ResourceCollection(resourceBases.toArray(new Resource[resourceBases.size()])));
    }

    protected List<Overlay> getOverlays() throws Exception {
        Overlay overlay;
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPlugin.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.warPlugin.getWarArtifact(config.getGroupId(), config.getArtifactId(), config.getClassifier());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            SelectiveJarResource r = new SelectiveJarResource(new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/"));
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay2 = new Overlay(config, (Resource)r);
            overlays.add(overlay2);
        }
        for (Artifact a : this.warPlugin.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            overlay = new Overlay(null, Resource.newResource((URL)new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/")));
            overlays.add(overlay);
        }
        return overlays;
    }

    protected Resource unpackOverlay(Overlay overlay) throws IOException {
        File dir;
        int i;
        if (overlay.getResource() == null) {
            return null;
        }
        String name = overlay.getResource().getName();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((i = name.lastIndexOf(47)) > 0) {
            name = name.substring(i + 1, name.length());
        }
        name = name.replace('.', '_');
        File overlaysDir = new File(this.warPlugin.getProject().getBuild().getDirectory(), "jetty_overlays");
        File unpackDir = dir = new File(overlaysDir, name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        overlay.unpackTo(unpackDir);
        return Resource.newResource((String)unpackDir.getCanonicalPath());
    }
}

