/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.internal.messages.MessageSink;
import org.eclipse.jetty.websocket.javax.common.decoders.RegisteredDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecodedMessageSink
implements MessageSink {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDecodedMessageSink.class);
    private final MethodHandle _methodHandle;
    private final MessageSink _messageSink;

    public AbstractDecodedMessageSink(CoreSession coreSession, MethodHandle methodHandle) {
        this._methodHandle = methodHandle;
        try {
            this._messageSink = this.newMessageSink(coreSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void invoke(Object message) {
        try {
            this._methodHandle.invoke(message);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }

    abstract MessageSink newMessageSink(CoreSession var1) throws Exception;

    public void accept(Frame frame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepting frame {} for {}", (Object)frame, (Object)this._messageSink);
        }
        this._messageSink.accept(frame, callback);
    }

    public static abstract class Stream<T extends Decoder>
    extends AbstractDecodedMessageSink {
        protected final T _decoder;

        public Stream(CoreSession coreSession, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
            super(coreSession, methodHandle);
            if (decoders.size() != 1) {
                throw new IllegalArgumentException("Require exactly one decoder for " + String.valueOf(this.getClass()));
            }
            this._decoder = decoders.get(0).getInstance();
        }
    }

    public static abstract class Basic<T extends Decoder>
    extends AbstractDecodedMessageSink {
        protected final List<T> _decoders;

        public Basic(CoreSession coreSession, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
            super(coreSession, methodHandle);
            if (decoders.isEmpty()) {
                throw new IllegalArgumentException("Require at least one decoder for " + String.valueOf(this.getClass()));
            }
            this._decoders = decoders.stream().map(RegisteredDecoder::getInstance).collect(Collectors.toList());
        }
    }
}

