/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class ViewerUpdater
implements IViewerUpdater {
    private final StructuredViewer viewer;

    protected ViewerUpdater(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public abstract void insert(Object var1, int var2);

    @Override
    public abstract void remove(Object var1, int var2);

    @Override
    public void replace(Object oldElement, Object newElement, int position) {
        ArrayList selectedElements = new ArrayList(this.viewer.getStructuredSelection().toList());
        this.remove(oldElement, position);
        this.insert(newElement, position);
        this.selectionContains(selectedElements, oldElement).ifPresent(iter -> {
            iter.remove();
            selectedElements.add(newElement);
            this.viewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        });
    }

    @Override
    public void move(Object element, int oldPosition, int newPosition) {
        if (this.isElementOrderPreserved()) {
            IStructuredSelection selection = this.viewer.getStructuredSelection();
            this.remove(element, oldPosition);
            this.insert(element, newPosition);
            this.selectionContains(selection.toList(), element).ifPresent(i -> this.viewer.setSelection((ISelection)selection));
        }
    }

    boolean isElementOrderPreserved() {
        return this.viewer.getComparator() == null && this.viewer.getFilters().length == 0;
    }

    private Optional<Iterator<?>> selectionContains(List<?> selection, Object element) {
        if (!selection.isEmpty()) {
            IElementComparer comparer = this.viewer.getComparer();
            Iterator<?> iter = selection.iterator();
            while (iter.hasNext()) {
                Object selectionElement = iter.next();
                if (!(comparer == null ? Util.equals((Object)element, selectionElement) : comparer.equals(element, selectionElement))) continue;
                return Optional.of(iter);
            }
        }
        return Optional.empty();
    }

    @Override
    public abstract void add(Object[] var1);

    @Override
    public abstract void remove(Object[] var1);
}

