/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.oomph.p2.core.AgentManagerElement;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentMap<E> {
    private final File file;
    private final File tempFile;
    private final File lockFile;
    private final Map<String, E> elements = new LinkedHashMap<String, E>();

    public PersistentMap(File file) {
        this.file = file;
        if (file != null) {
            File folder = file.getParentFile();
            folder.mkdirs();
            String name = file.getName();
            this.tempFile = new File(folder, String.valueOf(name) + ".temp");
            this.lockFile = IOUtil.canWriteFolder((File)folder) ? new File(folder, String.valueOf(name) + ".lock") : null;
        } else {
            this.tempFile = null;
            this.lockFile = null;
        }
    }

    public final void load() {
        final boolean[] needsSave = new boolean[1];
        if (this.file != null && this.file.exists()) {
            FileWriter lock = this.lock();
            try {
                this.load(new KeyHandler(){

                    @Override
                    public void handleKey(String key, String extraInfo) throws Exception {
                        AgentManagerElement agentManagerElement;
                        Object element = PersistentMap.this.loadElement(key, extraInfo);
                        if (element == null) {
                            needsSave[0] = true;
                            return;
                        }
                        if (element instanceof AgentManagerElement && !(agentManagerElement = (AgentManagerElement)element).isValid()) {
                            needsSave[0] = true;
                            return;
                        }
                        PersistentMap.this.elements.put(key, element);
                    }
                });
            }
            finally {
                this.unlock(lock);
            }
        } else {
            this.initializeFirstTime();
            needsSave[0] = true;
        }
        if (needsSave[0]) {
            this.save(null, null);
        }
    }

    public final File getFile() {
        return this.file;
    }

    public final synchronized Set<String> getElementKeys() {
        return new HashSet<String>(this.elements.keySet());
    }

    public final synchronized Collection<E> getElements() {
        return new ArrayList<E>(this.elements.values());
    }

    public final synchronized E getElement(String key) {
        return this.elements.get(key);
    }

    public final synchronized boolean containsElement(String key) {
        return this.elements.containsKey(key);
    }

    public final synchronized E addElement(String key, String extraInfo) {
        E element = this.elements.get(key);
        if (element == null && (element = this.createElement(key, extraInfo)) != null) {
            this.elements.put(key, element);
            this.save(key, null);
        }
        return element;
    }

    public final synchronized E remap(String oldKey, String newKey) {
        E element = this.elements.remove(oldKey);
        if (element != null) {
            this.elements.put(newKey, element);
            this.save(newKey, oldKey);
        }
        return element;
    }

    public final synchronized void removeElement(String key) {
        E element = this.elements.remove(key);
        if (element != null) {
            this.save(null, key);
        }
    }

    public final synchronized boolean refresh() {
        return this.reconcile(null, null);
    }

    protected E loadElement(String key, String extraInfo) {
        return this.createElement(key, extraInfo);
    }

    protected abstract E createElement(String var1, String var2);

    protected void initializeFirstTime() {
    }

    private void load(KeyHandler handler) {
        FileReader infoReader = null;
        try {
            try {
                String line;
                infoReader = new FileReader(this.file);
                BufferedReader bufferedReader = new BufferedReader(infoReader);
                while ((line = bufferedReader.readLine()) != null) {
                    try {
                        String extraInfo;
                        String key;
                        int pos = line.indexOf(124);
                        if (pos == -1) {
                            key = line;
                            extraInfo = null;
                        } else {
                            key = line.substring(0, pos);
                            extraInfo = line.substring(pos + 1);
                        }
                        handler.handleKey(key, extraInfo);
                    }
                    catch (Exception ex) {
                        P2CorePlugin.INSTANCE.log(ex);
                    }
                }
                IOUtil.close((Closeable)bufferedReader);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(infoReader);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)infoReader);
    }

    public void save(String addedKey, String removedKey) {
        if (this.file != null) {
            FileWriter lock = this.lock();
            FileWriter tempWriter = null;
            try {
                try {
                    if ((addedKey != null || removedKey != null) && this.file.exists()) {
                        this.reconcile(addedKey, removedKey);
                    }
                    tempWriter = new FileWriter(this.tempFile);
                    BufferedWriter bufferedWriter = new BufferedWriter(tempWriter);
                    ArrayList<String> sortedKeys = new ArrayList<String>(this.elements.keySet());
                    Collections.sort(sortedKeys);
                    for (String key : sortedKeys) {
                        bufferedWriter.write(key);
                        E element = this.elements.get(key);
                        if (element instanceof ExtraInfoProvider) {
                            String extraInfo = ((ExtraInfoProvider)element).getExtraInfo();
                            bufferedWriter.write(124);
                            bufferedWriter.write(extraInfo);
                        }
                        bufferedWriter.write(StringUtil.NL);
                    }
                    bufferedWriter.flush();
                    IOUtil.closeSilent((Closeable)tempWriter);
                    tempWriter = null;
                    this.file.delete();
                    this.tempFile.renameTo(this.file);
                }
                catch (IOException ex) {
                    throw new IORuntimeException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(tempWriter);
                this.unlock(lock);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)tempWriter);
            this.unlock(lock);
        }
    }

    private boolean reconcile(String addedKey, final String removedKey) {
        final boolean[] changed = new boolean[1];
        final HashSet<String> fileKeys = new HashSet<String>();
        fileKeys.add(addedKey);
        try {
            this.load(new KeyHandler(){

                @Override
                public void handleKey(String key, String extraInfo) throws Exception {
                    Object element;
                    fileKeys.add(key);
                    if (!key.equals(removedKey) && !PersistentMap.this.elements.containsKey(key) && (element = PersistentMap.this.createElement(key, extraInfo)) != null) {
                        PersistentMap.this.elements.put(key, element);
                        changed[0] = true;
                    }
                }
            });
        }
        catch (IORuntimeException ex) {
            P2CorePlugin.INSTANCE.log(ex, 2);
        }
        Iterator<String> it = this.elements.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (fileKeys.contains(key)) continue;
            it.remove();
            changed[0] = true;
        }
        return changed[0];
    }

    private FileWriter lock() {
        if (this.lockFile == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return new FileWriter(this.lockFile);
            }
            catch (IOException ex) {
                if (System.currentTimeMillis() - start >= 10000L) {
                    throw new RuntimeException("Acquisition of lock file " + this.lockFile + " timed out", ex);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex2) {
                    throw new RuntimeException("Acquisition of lock file " + this.lockFile + " interrupted", ex2);
                }
            }
        }
    }

    private void unlock(FileWriter lock) {
        if (lock != null) {
            try {
                IOUtil.close((Closeable)lock);
            }
            catch (Exception ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
            try {
                this.lockFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    public static interface ExtraInfoProvider {
        public String getExtraInfo();
    }

    private static interface KeyHandler {
        public void handleKey(String var1, String var2) throws Exception;
    }
}

