/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.WorkUnit;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Capture<T> {
    protected abstract T create(Shell var1);

    protected abstract Shell getShell(T var1);

    protected abstract void open(T var1);

    public Image capture() {
        final AtomicReference image = new AtomicReference();
        final Display display = PlatformUI.getWorkbench().getDisplay();
        final org.eclipse.jface.dialogs.Dialog backgroundDialog = new org.eclipse.jface.dialogs.Dialog(null){
            {
                super($anonymous0);
                this.setShellStyle(1024);
            }

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                control.setBackground(display.getSystemColor(1));
                return control;
            }
        };
        UIUtil.asyncExec(new Runnable(){

            public void run() {
                backgroundDialog.open();
            }
        });
        while (backgroundDialog.getShell() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        final Shell backgroundShell = backgroundDialog.getShell();
        final Object element = new WorkUnit<T, RuntimeException>(){

            @Override
            protected T doExecute() {
                backgroundShell.setMaximized(true);
                return Capture.this.create(backgroundShell);
            }
        }.execute();
        UIUtil.asyncExec(new Runnable(){

            public void run() {
                Capture.this.open(element);
            }
        });
        UIUtil.asyncExec(new Runnable(){

            public void run() {
                Shell shell = Capture.this.getShell(element);
                Rectangle bounds = shell.getBounds();
                bounds.x = 30;
                bounds.y = 50;
                shell.setBounds(bounds);
            }
        });
        while (!((Boolean)new WorkUnit<Boolean, RuntimeException>(){

            @Override
            protected Boolean doExecute() {
                return Capture.this.isReady(element);
            }
        }.execute()).booleanValue()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        new WorkUnit.Void<RuntimeException>(){

            @Override
            protected void doProcess() {
                Capture.this.preprocess(element);
            }
        }.execute();
        new WorkUnit.Void<RuntimeException>(){

            @Override
            protected void doProcess() {
                Capture.this.postProcess(element);
            }
        }.execute();
        new WorkUnit.Void<RuntimeException>(){

            @Override
            protected void doProcess() {
                image.set(Capture.this.capture(element));
            }
        }.execute();
        new WorkUnit.Void<RuntimeException>(){

            @Override
            protected void doProcess() {
                Capture.this.close(element);
                backgroundShell.close();
            }
        }.execute();
        return (Image)image.get();
    }

    protected Control getControl(T element) {
        return this.getShell(element);
    }

    protected boolean isReady(T element) {
        Shell shell = this.getShell(element);
        if (shell == null) {
            return false;
        }
        return shell.getShells().length <= 1;
    }

    protected void preprocess(T element) {
    }

    protected void postProcess(T element) {
        Button defaultButton = this.getShell(element).getDefaultButton();
        if (defaultButton != null) {
            ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(Button.class, (String)"setDefault", (Class[])new Class[]{Boolean.TYPE}), (Object)defaultButton, (Object[])new Object[]{false});
        }
    }

    protected Image capture(T element) {
        return AccessUtil.capture(this.getControl(element));
    }

    protected Image capture(IDialogPage page, Map<Control, Image> decorations) {
        Control control = page.getControl();
        Composite pageControl = control.getParent().getParent().getParent();
        Control[] children = pageControl.getChildren();
        Composite wizardControl = pageControl.getParent();
        Rectangle bounds = pageControl.getBounds();
        Point size = children[1].getSize();
        bounds.height += bounds.y - 2;
        bounds.y = 0;
        bounds.height -= size.y;
        Point displayOffset = wizardControl.toDisplay(bounds.x, bounds.y);
        Image result = AccessUtil.capture(control.getDisplay(), new Rectangle(displayOffset.x, displayOffset.y, bounds.width, bounds.height));
        if (decorations != null && !decorations.isEmpty()) {
            this.decorate(result, (Control)wizardControl, bounds, decorations);
        }
        return result;
    }

    protected void decorate(Image image, Control parent, Rectangle bounds, Map<Control, Image> decorations) {
        GC gc = new GC((Drawable)image);
        for (Map.Entry<Control, Image> entry : decorations.entrySet()) {
            Control control = entry.getKey();
            Image decoration = entry.getValue();
            if (decoration == null) continue;
            Rectangle controlBounds = control.getBounds();
            int border = control.getBorderWidth();
            Point controlLocation = control.getParent().toDisplay(controlBounds.x + controlBounds.width - 1 - border, controlBounds.y - border);
            Point relativeControlLocation = parent.toControl(controlLocation);
            Rectangle imageBounds = decoration.getBounds();
            imageBounds.x = bounds.x + relativeControlLocation.x - (imageBounds.width - 1) - 11;
            imageBounds.y = bounds.y + relativeControlLocation.y + 11;
            if (control instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)control;
                Rectangle clientArea = scrollable.getClientArea();
                imageBounds.x -= controlBounds.width - clientArea.width - 2 * border;
                if (control instanceof Tree) {
                    imageBounds.y += ((Tree)control).getHeaderHeight();
                }
                if (control instanceof Table) {
                    imageBounds.y += ((Table)control).getHeaderHeight();
                }
            }
            gc.drawImage(decoration, imageBounds.x, imageBounds.y);
        }
        gc.dispose();
    }

    protected Image getImage(Control control) {
        Point size = control.computeSize(-1, -1, true);
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            GC gc = new GC((Drawable)control);
            Point textExtent = gc.textExtent(combo.getText());
            size.x = textExtent.x + 30;
            gc.dispose();
        }
        control.setSize(size);
        AccessUtil.busyWait(10);
        Image result = AccessUtil.capture(control);
        return result;
    }

    protected <W extends Widget> W getWidget(T element, String key) {
        return (W)AccessUtil.getWidget((Widget)this.getShell(element), key);
    }

    protected Image getImage(T element, String key) {
        Object widget = AccessUtil.getWidget((Widget)this.getShell(element), key);
        if (widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)widget;
            Image image = toolItem.getImage();
            return new Image(image.getDevice(), image.getImageData());
        }
        if (widget instanceof Button) {
            Button button = (Button)widget;
            Shell shell = button.getShell();
            Color background = button.getBackground();
            boolean isEnabled = button.isEnabled();
            try {
                int style = button.getStyle();
                if ((style & 8) != 0) {
                    button.setBackground(shell.getDisplay().getSystemColor(1));
                }
                button.setEnabled(true);
                AccessUtil.busyWait(1000);
                Image image = AccessUtil.capture((Control)button);
                return image;
            }
            finally {
                button.setBackground(background);
                button.setEnabled(isEnabled);
            }
        }
        if (widget instanceof ProgressMonitorPart) {
            ProgressMonitorPart progressMonitorPart = (ProgressMonitorPart)widget;
            progressMonitorPart.setSize(170, progressMonitorPart.getSize().y);
            AccessUtil.busyWait(10);
            return AccessUtil.capture((Control)progressMonitorPart);
        }
        if (widget instanceof Text) {
            Text text = (Text)widget;
            return this.getImage((Control)text);
        }
        if (widget instanceof Combo) {
            Combo combo = (Combo)widget;
            return this.getImage((Control)combo);
        }
        if (widget instanceof Control) {
            Control control = (Control)widget;
            return AccessUtil.capture(control);
        }
        throw new UnsupportedOperationException("Unexpected widget " + widget);
    }

    protected void close(T element) {
        Shell shell = this.getShell(element);
        shell.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Dialog<D extends org.eclipse.swt.widgets.Dialog>
    extends Capture<D> {
        @Override
        protected Shell getShell(D dialog) {
            return dialog.getParent();
        }

        @Override
        protected void open(D dialog) {
            ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(dialog.getClass(), (String)"open", (Class[])new Class[0]), dialog, (Object[])new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Window<W extends org.eclipse.jface.window.Window>
    extends Capture<W> {
        @Override
        protected Shell getShell(W window) {
            return window.getShell();
        }

        @Override
        protected void open(W window) {
            window.open();
        }
    }
}

