/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

public interface ITargletContainerDescriptor {
    public static final String PROP_TARGLET_CONTAINER_WORKSPACE = "targlet.container.workspace";
    public static final String PROP_TARGLET_CONTAINER_ID = "targlet.container.id";
    public static final String PROP_TARGLET_CONTAINER_DIGEST = "targlet.container.digest";

    public String getID();

    public File getPoolLocation();

    public String getWorkingDigest();

    public Collection<WorkspaceIUInfo> getWorkingProjects();

    public UpdateProblem getUpdateProblem();

    public BundlePool getBundlePool();

    public String getWorkingProfileID();

    public Profile getWorkingProfile();

    public static class UpdateProblem
    implements Serializable,
    IStatus {
        private static final long serialVersionUID = 3L;
        private static final UpdateProblem[] NO_CHILDREN = new UpdateProblem[0];
        private String plugin;
        private String message;
        private int severity;
        private int code;
        private Throwable exception;
        private UpdateProblem[] children;

        public UpdateProblem() {
        }

        protected UpdateProblem(IStatus status) {
            this.plugin = status.getPlugin();
            this.message = status.getMessage();
            this.severity = status.getSeverity();
            this.code = status.getCode();
            this.exception = this.toSerializeableException(status.getException());
            IStatus[] statusChildren = status.getChildren();
            if (statusChildren != null && statusChildren.length != 0) {
                this.children = new UpdateProblem[statusChildren.length];
                int i = 0;
                while (i < statusChildren.length) {
                    IStatus statusChild = statusChildren[i];
                    this.children[i] = UpdateProblem.create(statusChild);
                    ++i;
                }
            }
        }

        public static UpdateProblem create(Throwable t) {
            return UpdateProblem.create(TargletsCorePlugin.INSTANCE.getStatus(t));
        }

        public static UpdateProblem create(IStatus status) {
            Explanation explanation;
            PlannerStatus plannerStatus;
            RequestStatus requestStatus;
            if (status instanceof PlannerStatus && (requestStatus = (plannerStatus = (PlannerStatus)status).getRequestStatus()) != null && (explanation = requestStatus.getExplanationDetails()) instanceof Explanation.MissingIU) {
                Explanation.MissingIU detailedExplanation = (Explanation.MissingIU)explanation;
                IRequirement req = detailedExplanation.req;
                if (P2Util.isSimpleRequiredCapability((IRequirement)req)) {
                    return new MissingIU(status, (IRequiredCapability)req);
                }
            }
            return new UpdateProblem(status);
        }

        public String getPlugin() {
            return this.plugin;
        }

        public String getMessage() {
            return this.message;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code;
        }

        public Throwable getException() {
            return this.exception;
        }

        public UpdateProblem[] getChildren() {
            return this.isMultiStatus() ? this.children : NO_CHILDREN;
        }

        public boolean isMultiStatus() {
            return this.children != null;
        }

        public boolean isOK() {
            return this.severity == 0;
        }

        public boolean matches(int severityMask) {
            return (this.severity & severityMask) != 0;
        }

        public IStatus toStatus() {
            if (this.isMultiStatus()) {
                IStatus[] statusChildren = new IStatus[this.children.length];
                int i = 0;
                while (i < this.children.length) {
                    statusChildren[i] = this.children[i].toStatus();
                    ++i;
                }
                return new MultiStatus(this.plugin, this.code, statusChildren, this.message, this.exception);
            }
            return new Status(this.severity, this.plugin, this.code, this.message, this.exception);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder, 0);
            return builder.toString();
        }

        private void toString(StringBuilder builder, int level) {
            int i = 0;
            while (i < level) {
                builder.append(' ');
                ++i;
            }
            switch (this.severity) {
                case 0: {
                    builder.append("OK ");
                    break;
                }
                case 1: {
                    builder.append("INFO ");
                    break;
                }
                case 2: {
                    builder.append("WARNING ");
                    break;
                }
                case 4: {
                    builder.append("ERROR ");
                    break;
                }
                case 8: {
                    builder.append("CANCEL ");
                }
            }
            builder.append(this.message);
            builder.append(StringUtil.NL);
        }

        private Throwable toSerializeableException(Throwable exception) {
            if (exception != null && !IOUtil.isSerializeable((Object)exception)) {
                if (exception instanceof CoreException) {
                    CoreException coreException = (CoreException)exception;
                    exception = new CoreException((IStatus)UpdateProblem.create(coreException.getStatus()));
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintWriter writer = new PrintWriter(baos);
                    exception.printStackTrace(writer);
                    writer.close();
                    exception = new RuntimeException(baos.toString());
                }
            }
            return exception;
        }

        public static final class MissingIU
        extends UpdateProblem {
            private static final long serialVersionUID = 1L;
            private String namespace;
            private String name;
            private String range;

            public MissingIU() {
            }

            protected MissingIU(IStatus status, IRequiredCapability requirement) {
                super(status);
                this.namespace = requirement.getNamespace();
                this.name = requirement.getName();
                this.range = requirement.getRange().toString();
            }

            public String getNamespace() {
                return this.namespace;
            }

            public String getName() {
                return this.name;
            }

            public String getRange() {
                return this.range;
            }
        }
    }
}

