/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.ComponentExtension;
import org.eclipse.oomph.targlets.ComponentGenerator;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.util.VersionGenerator;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentGeneratorImpl
extends ModelElementImpl
implements ComponentGenerator {
    private static final IPath DEFINITION_PATH = new Path("component.def");
    private static final IPath EXTENSION_PATH = new Path("component.ext");

    protected ComponentGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.COMPONENT_GENERATOR;
    }

    @Override
    public EList<IInstallableUnit> generateIUs(IProject project, String qualifierReplacement, Map<String, Version> iuVersions) throws Exception {
        IFile file = project.getFile(DEFINITION_PATH);
        if (file.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = file.getContents();
                Resource resource = new BaseResourceFactoryImpl().createResource(null);
                resource.load(inputStream, null);
                ComponentDefinition componentDefinition = (ComponentDefinition)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)TargletPackage.Literals.COMPONENT_DEFINITION);
                IInstallableUnit iu = ComponentGeneratorImpl.generateIU(componentDefinition, qualifierReplacement);
                EList eList = ECollections.singletonEList((Object)iu);
                return eList;
            }
            finally {
                IOUtil.closeSilent((Closeable)inputStream);
            }
        }
        return null;
    }

    @Override
    public void modifyIU(IInstallableUnit iu, IProject project, String qualifierReplacement, Map<String, Version> iuVersions) throws Exception {
        IFile file = project.getFile(EXTENSION_PATH);
        if (file.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = file.getContents();
                Resource resource = new BaseResourceFactoryImpl().createResource(null);
                resource.load(inputStream, null);
                ComponentExtension componentExtension = (ComponentExtension)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)TargletPackage.Literals.COMPONENT_EXTENSION);
                ComponentGeneratorImpl.modifyIU(componentExtension, iu);
            }
            finally {
                IOUtil.closeSilent((Closeable)inputStream);
            }
        }
    }

    public static IInstallableUnit generateIU(ComponentDefinition componentDefinition, String qualifierReplacement) throws Exception {
        String id = componentDefinition.getID();
        Version version = VersionGenerator.replaceQualifier(componentDefinition.getVersion(), qualifierReplacement);
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(id);
        description.setVersion(version);
        description.setProperty("org.eclipse.equinox.p2.type.group", "true");
        description.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version)));
        description.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        description.setArtifacts(new IArtifactKey[0]);
        if (!id.endsWith(".feature.group")) {
            description.addProvidedCapabilities(Arrays.asList(BundlesAction.BUNDLE_CAPABILITY, MetadataFactory.createProvidedCapability((String)"osgi.bundle", (String)id, (Version)version)));
        }
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        ComponentGeneratorImpl.modifyIU(componentDefinition, iu);
        return iu;
    }

    public static void modifyIU(ComponentExtension componentExtension, IInstallableUnit host) throws Exception {
        if (host instanceof InstallableUnit) {
            InstallableUnit iu = (InstallableUnit)host;
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>(iu.getRequirements());
            for (Requirement requirement : componentExtension.getRequirements()) {
                String id = requirement.getName();
                VersionRange versionRange = requirement.getVersionRange();
                String namespace = requirement.isFeature() ? "org.eclipse.equinox.p2.iu" : "osgi.bundle";
                requirements.add(MetadataFactory.createRequirement((String)namespace, (String)id, (VersionRange)versionRange, null, (boolean)requirement.isOptional(), (boolean)true, (boolean)true));
            }
            iu.setRequiredCapabilities(requirements.toArray(new IRequirement[requirements.size()]));
        }
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    return this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                try {
                    this.modifyIU((IInstallableUnit)arguments.get(0), (IProject)arguments.get(1), (String)arguments.get(2), (Map)arguments.get(3));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

