/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.win7;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Win7PaletteProvider {
    public static final Integer NORMAL_GRID_COLUMN_HEADER = 0;
    private static final Object[] NORMAL_GRID_COLUMN_HEADER_RGB = new Object[]{1, 1, 1, 1, new RGB(242, 242, 242), new RGB(239, 239, 239), new RGB(251, 251, 252), new RGB(247, 248, 249), new RGB(247, 248, 250), new RGB(241, 242, 244), new RGB(252, 252, 253), new RGB(251, 251, 252), new RGB(231, 232, 234), new RGB(222, 223, 225), new RGB(213, 213, 213), new RGB(251, 251, 251)};
    public static final Integer HOVER_GRID_COLUMN_HEADER = 1;
    private static final Object[] HOVER_GRID_COLUMN_HEADER_RGB;
    public static final Integer MOUSEDOWN_GRID_COLUMN_HEADER;
    private static final Object[] MOUSEDOWN_GRID_COLUMN_HEADER_RGB;
    public static final Integer SELECTED_GRID_COLUMN_HEADER;
    private static final Object[] SELECTED_GRID_COLUMN_HEADER_RGB;
    public static final Integer SHADOW_GRID_COLUMN_HEADER;
    private static final Object[] SHADOW_GRID_COLUMN_HEADER_RGB;
    private final Map<Integer, Palette> palettes = new HashMap<Integer, Palette>();

    static {
        Object[] objectArray = new Object[16];
        objectArray[0] = 1;
        objectArray[1] = new RGB(136, 203, 235);
        objectArray[2] = new RGB(227, 247, 255);
        objectArray[3] = new RGB(227, 247, 255);
        objectArray[5] = new RGB(136, 203, 235);
        objectArray[7] = new RGB(105, 187, 227);
        objectArray[9] = new RGB(183, 231, 251);
        objectArray[11] = new RGB(183, 231, 251);
        objectArray[13] = new RGB(105, 187, 227);
        objectArray[14] = new RGB(147, 201, 227);
        objectArray[15] = new RGB(251, 251, 251);
        HOVER_GRID_COLUMN_HEADER_RGB = objectArray;
        MOUSEDOWN_GRID_COLUMN_HEADER = 3;
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = 1;
        objectArray2[1] = new RGB(122, 158, 177);
        objectArray2[2] = new RGB(188, 228, 249);
        objectArray2[3] = new RGB(162, 203, 224);
        objectArray2[5] = new RGB(122, 158, 177);
        objectArray2[6] = new RGB(80, 145, 175);
        objectArray2[7] = new RGB(77, 141, 173);
        objectArray2[8] = new RGB(141, 214, 247);
        objectArray2[9] = new RGB(138, 209, 245);
        objectArray2[10] = new RGB(114, 188, 223);
        objectArray2[11] = new RGB(110, 184, 220);
        objectArray2[12] = new RGB(80, 145, 175);
        objectArray2[13] = new RGB(77, 141, 173);
        objectArray2[14] = new RGB(147, 201, 227);
        objectArray2[15] = new RGB(251, 251, 251);
        MOUSEDOWN_GRID_COLUMN_HEADER_RGB = objectArray2;
        SELECTED_GRID_COLUMN_HEADER = 3;
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = 1;
        objectArray3[1] = new RGB(150, 217, 249);
        objectArray3[2] = new RGB(242, 249, 252);
        objectArray3[3] = new RGB(242, 249, 252);
        objectArray3[5] = new RGB(150, 217, 249);
        objectArray3[7] = new RGB(150, 217, 249);
        objectArray3[8] = new RGB(225, 241, 249);
        objectArray3[9] = new RGB(216, 236, 246);
        objectArray3[10] = new RGB(225, 241, 249);
        objectArray3[11] = new RGB(216, 236, 246);
        objectArray3[13] = new RGB(150, 217, 249);
        objectArray3[14] = new RGB(150, 217, 249);
        objectArray3[15] = 1;
        SELECTED_GRID_COLUMN_HEADER_RGB = objectArray3;
        SHADOW_GRID_COLUMN_HEADER = 4;
        SHADOW_GRID_COLUMN_HEADER_RGB = new Object[]{new RGB(134, 163, 178), new RGB(170, 206, 225)};
    }

    public void dispose() {
        Iterator<Palette> it = this.palettes.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }

    public void initializePalette(Display display, Integer type) {
        this.getPalette(display, type);
    }

    public Palette getPalette(Display display, Integer type) {
        Palette palette = this.palettes.get(type);
        if (palette != null) {
            return palette;
        }
        if (type == NORMAL_GRID_COLUMN_HEADER) {
            return this.createPalette(display, type, NORMAL_GRID_COLUMN_HEADER_RGB);
        }
        if (type == HOVER_GRID_COLUMN_HEADER) {
            return this.createPalette(display, type, HOVER_GRID_COLUMN_HEADER_RGB);
        }
        if (type == MOUSEDOWN_GRID_COLUMN_HEADER) {
            return this.createPalette(display, type, MOUSEDOWN_GRID_COLUMN_HEADER_RGB);
        }
        if (type == SHADOW_GRID_COLUMN_HEADER) {
            return this.createPalette(display, type, SHADOW_GRID_COLUMN_HEADER_RGB);
        }
        if (type == SELECTED_GRID_COLUMN_HEADER) {
            return this.createPalette(display, type, SELECTED_GRID_COLUMN_HEADER_RGB);
        }
        return null;
    }

    protected Palette createPalette(Display display, Integer type, Object[] def) {
        Color[] colors = new Color[def.length];
        int i = 0;
        while (i < colors.length) {
            colors[i] = def[i] == null ? null : (def[i] instanceof Integer ? (display == null ? Display.getCurrent() : display).getSystemColor(((Integer)def[i]).intValue()) : new Color((RGB)def[i]));
            ++i;
        }
        return new Palette(type, colors);
    }

    public class Palette {
        private final Integer type;
        private Color[] colors = new Color[0];

        public Palette(Integer type, Color[] colors) {
            this.type = type;
            this.colors = colors;
        }

        public Integer getType() {
            return this.type;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public void dispose() {
            if (this.colors != null) {
                int i = 0;
                while (i < this.colors.length) {
                    if (this.colors[i] != null) {
                        this.colors[i].dispose();
                    }
                    ++i;
                }
            }
        }
    }
}

