/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.treemapper.internal;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class LinkFigure {
    private IFigure parent;
    private Polyline leftLine = new Polyline();
    private Polyline rightLine;
    private Point leftPoint;
    private Point rightPoint;

    public LinkFigure(IFigure parent) {
        this.leftLine.setAntialias(1);
        this.rightLine = new Polyline();
        this.rightLine.setAntialias(1);
        parent.add((IFigure)this.leftLine);
        parent.add((IFigure)this.rightLine);
        this.parent = parent;
    }

    public void setLeftPoint(int x, int y) {
        this.leftPoint = new Point(x, y);
        this.updateFigures();
    }

    public void setRightPoint(int x, int y) {
        this.rightPoint = new Point(x, y);
        this.updateFigures();
    }

    public void setLeftMappingVisible(boolean leftItemVisible) {
        if (leftItemVisible) {
            this.leftLine.setLineStyle(1);
        } else {
            this.leftLine.setLineStyle(2);
        }
    }

    private void updateFigures() {
        if (this.leftPoint != null && this.rightPoint != null) {
            Point middlePoint = new Rectangle(this.leftPoint, this.rightPoint).getCenter();
            PointList leftPointList = new PointList(2);
            leftPointList.addPoint(this.leftPoint);
            leftPointList.addPoint(middlePoint);
            this.leftLine.setPoints(leftPointList);
            PointList rightPointList = new PointList(2);
            rightPointList.addPoint(middlePoint);
            rightPointList.addPoint(this.rightPoint);
            this.rightLine.setPoints(rightPointList);
        }
    }

    public void setRightMappingVisible(boolean rightItemVisible) {
        if (rightItemVisible) {
            this.rightLine.setLineStyle(1);
        } else {
            this.rightLine.setLineStyle(2);
        }
    }

    public void setLineWidth(int lineWidth) {
        this.leftLine.setLineWidth(lineWidth);
        this.rightLine.setLineWidth(lineWidth);
    }

    public void deleteFromParent() {
        this.parent.remove((IFigure)this.leftLine);
        this.parent.remove((IFigure)this.rightLine);
    }

    public void seLineColor(Color color) {
        this.leftLine.setForegroundColor(color);
        this.rightLine.setForegroundColor(color);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.leftLine.addMouseListener(mouseListener);
        this.rightLine.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.leftLine.addMouseMotionListener(mouseMotionListener);
        this.rightLine.addMouseMotionListener(mouseMotionListener);
    }
}

