/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.promptsupport;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;

abstract class BaseFocusControlListener<T extends Control>
implements FocusListener {
    protected T control;
    private Font initialFont;
    private Color initialBackgroundColor;
    private Color initialForegroundColor;
    protected static final String EMPTY_STRING = "";

    BaseFocusControlListener(T control) {
        this.control = control;
    }

    public void focusGained(FocusEvent e) {
        if (this.isFilled()) {
            PromptSupport.setPromptDisplayed(this.control, false);
            return;
        }
        this.applyInitialLook();
        PromptSupport.setPromptDisplayed(this.control, true);
        if (PromptSupport.getFocusBehavior(this.control) == PromptSupport.FocusBehavior.HIDE_PROMPT) {
            this.hidePrompt();
        } else {
            this.highLightPrompt();
        }
    }

    protected void applyInitialLook() {
        this.control.setFont(this.initialFont);
        this.control.setBackground(this.initialBackgroundColor);
        this.control.setForeground(this.initialForegroundColor);
    }

    protected void applyPromptLook() {
        Font font = SWTGraphicUtil.buildFontFrom(this.control, (int)PromptSupport.getFontStyle(this.control));
        this.control.setFont(font);
        SWTGraphicUtil.addDisposer(this.control, (Resource[])new Resource[]{font});
        this.control.setBackground(PromptSupport.getBackground(this.control));
        this.control.setForeground(PromptSupport.getForeground(this.control));
    }

    protected abstract void hidePrompt();

    protected abstract void highLightPrompt();

    public void focusLost(FocusEvent e) {
        if (this.isFilled()) {
            PromptSupport.setPromptDisplayed(this.control, false);
            return;
        }
        this.storeInitialLook();
        this.applyPromptLook();
        this.fillPromptText();
        PromptSupport.setPromptDisplayed(this.control, true);
    }

    protected abstract boolean isFilled();

    protected abstract void fillPromptText();

    protected void storeInitialLook() {
        this.initialFont = this.control.getFont();
        this.initialBackgroundColor = this.control.getBackground();
        this.initialForegroundColor = this.control.getForeground();
    }

    void hookControl() {
        boolean isPromptDisplayed = false;
        this.storeInitialLook();
        if (!this.control.isFocusControl() && !this.isFilled()) {
            this.applyPromptLook();
            this.fillPromptText();
            isPromptDisplayed = true;
        }
        PromptSupport.setPromptDisplayed(this.control, isPromptDisplayed);
        this.control.addFocusListener((FocusListener)this);
    }
}

