/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedByteStack;

public class UnmodifiableByteStack
implements MutableByteStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteStack stack;

    public UnmodifiableByteStack(MutableByteStack stack) {
        this.stack = Objects.requireNonNull(stack);
    }

    public void push(byte item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public byte pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public ByteList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public byte peek() {
        return this.stack.peek();
    }

    public ByteList peek(int count) {
        return this.stack.peek(count);
    }

    public byte peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(byte value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.stack.containsAll(source);
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.stack.byteIterator());
    }

    public void each(ByteProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableByteStack select(BytePredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableByteStack reject(BytePredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public byte max() {
        return this.stack.max();
    }

    public byte min() {
        return this.stack.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableByteList toSortedList() {
        return this.stack.toSortedList();
    }

    public byte[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public byte[] toArray() {
        return this.stack.toArray();
    }

    public byte[] toArray(byte[] target) {
        return this.stack.toArray(target);
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableByteList toList() {
        return this.stack.toList();
    }

    public MutableByteSet toSet() {
        return this.stack.toSet();
    }

    public MutableByteBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public MutableByteStack asUnmodifiable() {
        return this;
    }

    public MutableByteStack asSynchronized() {
        return new SynchronizedByteStack(this);
    }

    public ImmutableByteStack toImmutable() {
        return ByteStacks.immutable.withAllReversed((ByteIterable)this);
    }

    public MutableByteStack newEmpty() {
        return this.stack.newEmpty();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectInto(injectedValue, function);
    }

    public RichIterable<ByteIterable> chunk(int size) {
        return this.stack.chunk(size);
    }

    public byte getFirst() {
        return this.stack.getFirst();
    }

    public int indexOf(byte value) {
        return this.stack.indexOf(value);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectIntoWithIndex(injectedValue, function);
    }

    public void forEachWithIndex(ByteIntProcedure procedure) {
        this.stack.forEachWithIndex(procedure);
    }

    public <V> MutableStack<V> collectWithIndex(ByteIntToObjectFunction<? extends V> function) {
        return this.stack.collectWithIndex(function);
    }

    public <V, R extends Collection<V>> R collectWithIndex(ByteIntToObjectFunction<? extends V> function, R target) {
        return (R)this.stack.collectWithIndex(function, target);
    }

    public MutableByteStack toStack() {
        return this.stack.toStack();
    }
}

