/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerRegistry<T extends ExtendedLogger> {
    private final Map<String, Map<MessageFactory, WeakReference<T>>> loggerRefByMessageFactoryByName = new HashMap<String, Map<MessageFactory, WeakReference<T>>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public LoggerRegistry() {
    }

    public LoggerRegistry(MapFactory<T> mapFactory) {
        this();
    }

    public T getLogger(String name) {
        Objects.requireNonNull(name, "name");
        return this.getLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLogger(String name, MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        this.readLock.lock();
        try {
            Map<MessageFactory, WeakReference<T>> loggerRefByMessageFactory = this.loggerRefByMessageFactoryByName.get(name);
            if (loggerRefByMessageFactory == null) {
                T t = null;
                return t;
            }
            MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : ParameterizedMessageFactory.INSTANCE;
            WeakReference<T> loggerRef = loggerRefByMessageFactory.get(effectiveMessageFactory);
            if (loggerRef == null) {
                T t = null;
                return t;
            }
            ExtendedLogger extendedLogger = (ExtendedLogger)loggerRef.get();
            return (T)extendedLogger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<T> getLoggers() {
        return this.getLoggers(new ArrayList());
    }

    public Collection<T> getLoggers(Collection<T> destination) {
        Objects.requireNonNull(destination, "destination");
        this.readLock.lock();
        try {
            this.loggerRefByMessageFactoryByName.values().stream().flatMap(loggerRefByMessageFactory -> loggerRefByMessageFactory.values().stream().map(Reference::get)).filter(Objects::nonNull).forEach(destination::add);
        }
        finally {
            this.readLock.unlock();
        }
        return destination;
    }

    public boolean hasLogger(String name) {
        Objects.requireNonNull(name, "name");
        T logger = this.getLogger(name);
        return logger != null;
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        T logger = this.getLogger(name, messageFactory);
        return logger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactoryClass, "messageFactoryClass");
        this.readLock.lock();
        try {
            boolean bl = this.loggerRefByMessageFactoryByName.getOrDefault(name, Collections.emptyMap()).keySet().stream().anyMatch(messageFactory -> messageFactoryClass.equals(messageFactory.getClass()));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfAbsent(String name, MessageFactory messageFactory, T logger) {
        Objects.requireNonNull(logger, "logger");
        this.writeLock.lock();
        try {
            Map loggerRefByMessageFactory = this.loggerRefByMessageFactoryByName.computeIfAbsent(logger.getName(), this::createLoggerRefByMessageFactoryMap);
            Object loggerMessageFactory = logger.getMessageFactory();
            WeakReference loggerRef = (WeakReference)loggerRefByMessageFactory.get(loggerMessageFactory);
            if (loggerRef == null || loggerRef.get() == null) {
                loggerRefByMessageFactory.put(loggerMessageFactory, new WeakReference<T>(logger));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<MessageFactory, WeakReference<T>> createLoggerRefByMessageFactoryMap(String ignored) {
        return new WeakHashMap<MessageFactory, WeakReference<T>>();
    }

    public static class WeakMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new WeakHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new WeakHashMap<String, Map<String, T>>();
        }

        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            innerMap.put(name, logger);
        }
    }

    public static class ConcurrentMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new ConcurrentHashMap<String, Map<String, T>>();
        }

        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            innerMap.putIfAbsent(name, logger);
        }
    }

    public static interface MapFactory<T extends ExtendedLogger> {
        public Map<String, T> createInnerMap();

        public Map<String, Map<String, T>> createOuterMap();

        public void putIfAbsent(Map<String, T> var1, String var2, T var3);
    }
}

