/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class ArrayUtil {
    public static final String[] STRING_TYPE_ARRAY = new String[0];
    public static final int[] INT_TYPE_ARRAY = new int[0];

    private ArrayUtil() {
    }

    public static <T> List<T> asList(T[] array) {
        return new ArrayList<T>(ArrayUtil.asCollection(array));
    }

    public static <T> Collection<T> asCollection(T[] array) {
        return Arrays.asList(array);
    }

    public static int[] asIntArray(int ... ints) {
        return ints;
    }

    public static List<Integer> asIntegerList(int ... ints) {
        return Arrays.stream(ints).boxed().collect(Collectors.toList());
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(String[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(String[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static int[] asIntArray(Collection<Integer> list) {
        int[] ints = new int[list.size()];
        int i = 0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int fromSet;
            ints[i] = fromSet = iterator.next().intValue();
            ++i;
        }
        return ints;
    }

    public static int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return new int[0];
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return new int[0];
        }
        int[] subarray = new int[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }
}

