/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import java.util.function.Supplier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.e4.ui.css.swt.dom.IHeaderCustomizationElement;
import org.eclipse.e4.ui.css.swt.dom.ISelectionBackgroundCustomizationElement;
import org.eclipse.e4.ui.internal.css.swt.dom.AbstractControlSelectionEraseListener;
import org.eclipse.e4.ui.internal.css.swt.dom.ControlSelectedColorCustomization;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeElement
extends ControlElement
implements ISelectionBackgroundCustomizationElement,
IHeaderCustomizationElement {
    private static boolean showedUnsupportedWarning = false;
    private static final String TREE_ARROWS_FOREGROUND_COLOR = "org.eclipse.e4.ui.css.swt.treeArrowsForegroundColor";
    private static final String TREE_ARROWS_MODE = "org.eclipse.e4.ui.css.swt.treeArrowsMode";
    private static final String TREE_ARROWS_MODE_TRIANGLE = "triangle";
    private static final String TREE_ARROWS_MODE_SQUARE = "square";
    private static final TreeItemPaintListener treeItemSquaresPaintListener = new TreeItemPaintListener(){

        @Override
        protected void draw(TreeItem treeItem, Color foreground, Color background, Event event, int baseX) {
            GC gc = event.gc;
            int w = 9;
            int h = 9;
            int x = baseX;
            int y = event.y + 4;
            int halfH = h / 2;
            gc.drawRectangle(x + 1, y + 1, w - 1, h - 1);
            gc.drawLine(x + 3, y + halfH + 1, x + w - 2, y + halfH + 1);
            if (!treeItem.getExpanded()) {
                int halfW = w / 2;
                gc.drawLine(x + halfW + 1, y + 3, x + halfW + 1, y + h - 2);
            }
            event.detail &= 0xFFFFFFF7;
        }
    };
    private static final TreeItemPaintListener treeItemArrowsPaintListener = new TreeItemPaintListener(){

        @Override
        protected void draw(TreeItem treeItem, Color foreground, Color background, Event event, int baseX) {
            GC gc = event.gc;
            int w = 9;
            int h = 9;
            int x = baseX;
            int y = event.y + 4;
            int halfH = h / 2;
            if (!treeItem.getExpanded()) {
                int px0 = x + 1;
                int py0 = y + 1;
                int py1 = y + halfH + 1;
                int px1 = x + w / 2 + 1;
                int py2 = y + h;
                gc.drawLine(px0, py0, px0, py2);
                gc.drawLine(px0, py0, px1, py1);
                gc.drawLine(px0, py2, px1, py1);
            } else {
                int px0 = x;
                int py0 = y;
                int px1 = x + w - 2;
                int py2 = y + h - 2;
                gc.setBackground(foreground);
                gc.fillPolygon(new int[]{px1, py0, px1, py2, px0, py2, px1, py0});
                gc.setBackground(background);
            }
            event.detail &= 0xFFFFFFF7;
        }
    };
    private final ControlSelectedColorCustomization fControlSelectedColorCustomization;

    public TreeElement(Tree tree, CSSEngine engine) {
        super((Control)tree, engine);
        this.fControlSelectedColorCustomization = new ControlSelectedColorCustomization((Control)tree, new TreeControlSelectionEraseListener());
    }

    public Tree getTree() {
        return (Tree)this.getNativeWidget();
    }

    @Override
    public void reset() {
        this.setTreeArrowsForegroundColor(null);
        this.setHeaderColor(null);
        this.setHeaderBackgroundColor(null);
        super.reset();
    }

    private void setPaintListener(Color color) {
        if ("win32".equals(Platform.getOS())) {
            Tree tree = this.getTree();
            tree.removeListener(42, (Listener)treeItemSquaresPaintListener);
            tree.removeListener(42, (Listener)treeItemArrowsPaintListener);
            if (color != null) {
                String treeArrowsMode = this.getTreeArrowsMode();
                if (TREE_ARROWS_MODE_TRIANGLE.equals(treeArrowsMode)) {
                    tree.addListener(42, (Listener)treeItemArrowsPaintListener);
                } else if (TREE_ARROWS_MODE_SQUARE.equals(treeArrowsMode)) {
                    tree.addListener(42, (Listener)treeItemSquaresPaintListener);
                } else if (!showedUnsupportedWarning) {
                    System.err.println("Unsupported swt-tree-arrow-mode: " + treeArrowsMode);
                    showedUnsupportedWarning = true;
                }
            }
        } else if (!showedUnsupportedWarning) {
            System.err.println("swt-tree-arrow-mode and swt-tree-arrow-color are not supported on this platform");
            showedUnsupportedWarning = true;
        }
    }

    public void setTreeArrowsForegroundColor(Color color) {
        Tree tree = this.getTree();
        tree.setData(TREE_ARROWS_FOREGROUND_COLOR, (Object)color);
        this.setPaintListener(color);
    }

    public Color getTreeArrowsForegroundColor() {
        Tree tree = this.getTree();
        Object data = tree.getData(TREE_ARROWS_FOREGROUND_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }

    public void setTreeArrowsMode(String arrowsMode) {
        Tree tree = this.getTree();
        if (arrowsMode == null) {
            tree.setData(TREE_ARROWS_MODE, null);
            this.setPaintListener(this.getTreeArrowsForegroundColor());
            return;
        }
        Assert.isTrue((TREE_ARROWS_MODE_TRIANGLE.equals(arrowsMode) || TREE_ARROWS_MODE_SQUARE.equals(arrowsMode) ? 1 : 0) != 0);
        tree.setData(TREE_ARROWS_MODE, (Object)arrowsMode);
    }

    public String getTreeArrowsMode() {
        Tree tree = this.getTree();
        Object data = tree.getData(TREE_ARROWS_MODE);
        if (TREE_ARROWS_MODE_TRIANGLE.equals(data) || TREE_ARROWS_MODE_SQUARE.equals(data)) {
            return (String)data;
        }
        return TREE_ARROWS_MODE_TRIANGLE;
    }

    @Override
    public void setSelectionBackgroundColor(Color color) {
        this.fControlSelectedColorCustomization.setSelectionBackgroundColor(color);
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.fControlSelectedColorCustomization.getSelectionBackgroundColor();
    }

    @Override
    public void setSelectionBorderColor(Color color) {
        this.fControlSelectedColorCustomization.setSelectionBorderColor(color);
    }

    @Override
    public Color getSelectionBorderColor() {
        return this.fControlSelectedColorCustomization.getSelectionBorderColor();
    }

    @Override
    public void setHotBackgroundColor(Color color) {
        this.fControlSelectedColorCustomization.setHotBackgroundColor(color);
    }

    @Override
    public Color getHotBackgroundColor() {
        return this.fControlSelectedColorCustomization.getHotBackgroundColor();
    }

    @Override
    public void setHotBorderColor(Color color) {
        this.fControlSelectedColorCustomization.setHotBorderColor(color);
    }

    @Override
    public Color getHotBorderColor() {
        return this.fControlSelectedColorCustomization.getHotBorderColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.fControlSelectedColorCustomization.getSelectionForegroundColor();
    }

    @Override
    public void setSelectionForegroundColor(Color color) {
        this.fControlSelectedColorCustomization.setSelectionForegroundColor(color);
    }

    @Override
    public void setHeaderColor(Color color) {
        this.getTree().setHeaderForeground(color);
    }

    @Override
    public void setHeaderBackgroundColor(Color color) {
        this.getTree().setHeaderBackground(color);
    }

    @Override
    protected Supplier<String> internalGetAttribute(String attr) {
        if ("swt-lines-visible".equals(attr)) {
            Tree tree = this.getTree();
            return () -> String.valueOf(tree.getLinesVisible());
        }
        return super.internalGetAttribute(attr);
    }

    private static class TreeControlSelectionEraseListener
    extends AbstractControlSelectionEraseListener {
        private TreeControlSelectionEraseListener() {
        }

        @Override
        protected void fixEventDetail(Control control, Event event) {
            event.detail &= 0xFFFFFFFD;
        }

        @Override
        protected int getNumberOfColumns(Control control) {
            return ((Tree)control).getColumnCount();
        }
    }

    private static abstract class TreeItemPaintListener
    implements Listener {
        private TreeItemPaintListener() {
        }

        public void handleEvent(Event event) {
            Widget item = event.item;
            if (!(item instanceof TreeItem)) {
                return;
            }
            TreeItem treeItem = (TreeItem)item;
            if (treeItem.getItemCount() == 0) {
                return;
            }
            Tree parent = treeItem.getParent();
            boolean isCheckTree = (parent.getStyle() & 0x20) != 0;
            Object data = parent.getData(TreeElement.TREE_ARROWS_FOREGROUND_COLOR);
            if (!(data instanceof Color)) {
                return;
            }
            Color foreground = (Color)data;
            Color background = null;
            if ((event.detail & 2) != 0) {
                background = ControlSelectedColorCustomization.getSelectionBackgroundColor((Control)parent);
            } else if ((event.detail & 0x20) != 0) {
                background = ControlSelectedColorCustomization.getHotBackgroundColor((Control)parent);
            }
            if (background == null) {
                background = parent.getBackground();
            }
            GC gc = event.gc;
            gc.setForeground(foreground);
            if (background != null) {
                gc.setBackground(background);
            }
            int baseX = isCheckTree ? event.x - 32 : event.x - 16;
            gc.fillRectangle(baseX, event.y + 4, 10, 11);
            this.draw(treeItem, foreground, background, event, baseX);
        }

        protected abstract void draw(TreeItem var1, Color var2, Color var3, Event var4, int var5);
    }
}

