/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Rectangle;

public class FillHandlePasteCommandHandler
implements ILayerCommandHandler<FillHandlePasteCommand> {
    protected SelectionLayer selectionLayer;
    protected InternalCellClipboard clipboard;

    public FillHandlePasteCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, FillHandlePasteCommand command) {
        if (this.clipboard.getCopiedCells() != null) {
            int pasteColumn = -1;
            int pasteRow = -1;
            int pasteWidth = this.clipboard.getCopiedCells().length;
            int pasteHeight = this.clipboard.getCopiedCells()[0].length;
            Rectangle handleRegion = this.selectionLayer.getFillHandleRegion();
            if (handleRegion != null) {
                pasteColumn = handleRegion.x;
                pasteRow = handleRegion.y;
                pasteWidth = handleRegion.width;
                pasteHeight = handleRegion.height;
            } else {
                PositionCoordinate coord = this.selectionLayer.getSelectionAnchor();
                pasteColumn = coord.getColumnPosition();
                pasteRow = coord.getRowPosition();
            }
            int pasteStartColumn = pasteColumn;
            int rowStartAdjustment = 0;
            if (command.direction == SelectionLayer.MoveDirectionEnum.UP) {
                rowStartAdjustment = pasteHeight % this.clipboard.getCopiedCells().length;
            }
            int columnStartAdjustment = 0;
            if (command.direction == SelectionLayer.MoveDirectionEnum.LEFT) {
                columnStartAdjustment = pasteWidth % this.clipboard.getCopiedCells()[0].length;
            }
            int i = 0;
            while (i < pasteHeight) {
                ILayerCell[] cells = this.clipboard.getCopiedCells()[(i + rowStartAdjustment) % this.clipboard.getCopiedCells().length];
                int j = 0;
                while (j < pasteWidth) {
                    ILayerCell cell = cells[(j + columnStartAdjustment) % this.clipboard.getCopiedCells()[0].length];
                    Object cellValue = this.getPasteValue(cell, command, pasteColumn, pasteRow);
                    if (EditUtils.isCellEditable(new PositionCoordinate(this.selectionLayer, pasteColumn, pasteRow), command.configRegistry)) {
                        this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, pasteColumn, pasteRow, cellValue));
                    }
                    if (++pasteColumn >= this.selectionLayer.getColumnCount()) break;
                    ++j;
                }
                ++pasteRow;
                pasteColumn = pasteStartColumn;
                ++i;
            }
        }
        return true;
    }

    protected Object getPasteValue(ILayerCell cell, FillHandlePasteCommand command, int toColumn, int toRow) {
        if (cell != null) {
            switch (command.operation) {
                case COPY: {
                    return cell.getDataValue();
                }
                case SERIES: {
                    Number diff = 0;
                    if (command.direction == SelectionLayer.MoveDirectionEnum.LEFT || command.direction == SelectionLayer.MoveDirectionEnum.RIGHT) {
                        diff = this.calculateVerticalDiff(cell, toColumn, command.configRegistry);
                    } else if (command.direction == SelectionLayer.MoveDirectionEnum.UP || command.direction == SelectionLayer.MoveDirectionEnum.DOWN) {
                        diff = this.calculateHorizontalDiff(cell, toRow, command.configRegistry);
                    }
                    Object value = cell.getDataValue();
                    if (diff != null) {
                        if (value instanceof Byte) {
                            return (byte)((Byte)value + (Byte)diff);
                        }
                        if (value instanceof Short) {
                            return (short)((Short)value + (Short)diff);
                        }
                        if (value instanceof Integer) {
                            return (Integer)value + (Integer)diff;
                        }
                        if (value instanceof Long) {
                            return (Long)value + (Long)diff;
                        }
                        if (value instanceof Float) {
                            return Float.valueOf(((Float)value).floatValue() + ((Float)diff).floatValue());
                        }
                        if (value instanceof Double) {
                            return (Double)value + (Double)diff;
                        }
                        if (value instanceof BigInteger) {
                            return ((BigInteger)value).add((BigInteger)diff);
                        }
                        if (value instanceof BigDecimal) {
                            return ((BigDecimal)value).add((BigDecimal)diff);
                        }
                        if (value instanceof Date) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime((Date)value);
                            cal.add(this.getIncrementDateField(cell, command.configRegistry), (Integer)diff);
                            return cal.getTime();
                        }
                    }
                    return value;
                }
            }
            return cell.getDataValue();
        }
        return null;
    }

    protected Number calculateHorizontalDiff(ILayerCell cell, int toRow, IConfigRegistry configRegistry) {
        Class<?> type = cell.getDataValue() != null ? cell.getDataValue().getClass() : null;
        ILayerCell[][] cells = this.clipboard.getCopiedCells();
        int rowDiff = this.getRowDiff(cell, toRow);
        if (cells.length == 1) {
            return this.getCastValue(rowDiff, type);
        }
        if (type != null) {
            int columnArrayIndex = cell.getColumnIndex() - this.clipboard.getCopiedCells()[0][0].getColumnIndex();
            if (type == Byte.class) {
                Byte diff = this.calculateByteDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Byte temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateByteDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return (byte)(diff * rowDiff);
            }
            if (type == Short.class) {
                Short diff = this.calculateShortDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Short temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateShortDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return (short)(diff * rowDiff);
            }
            if (type == Integer.class) {
                Integer diff = this.calculateIntDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Integer temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateIntDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * rowDiff;
            }
            if (type == Long.class) {
                Long diff = this.calculateLongDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Long temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateLongDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * (long)rowDiff;
            }
            if (type == Float.class) {
                Float diff = this.calculateFloatDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Float temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateFloatDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return Float.valueOf(BigDecimal.valueOf(diff.floatValue()).multiply(BigDecimal.valueOf(rowDiff)).floatValue());
            }
            if (type == Double.class) {
                Double diff = this.calculateDoubleDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                Double temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateDoubleDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return BigDecimal.valueOf(diff).multiply(BigDecimal.valueOf(rowDiff)).doubleValue();
            }
            if (type == BigInteger.class) {
                BigInteger diff = this.calculateBigIntegerDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                BigInteger temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateBigIntegerDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff.multiply(BigInteger.valueOf(rowDiff));
            }
            if (type == BigDecimal.class) {
                BigDecimal diff = this.calculateBigDecimalDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex]);
                if (diff == null) {
                    return null;
                }
                BigDecimal temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateBigDecimalDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff.multiply(BigDecimal.valueOf(rowDiff));
            }
            if (type == Date.class) {
                Integer diff = this.calculateDateDiff(cells[1][columnArrayIndex], cells[0][columnArrayIndex], configRegistry);
                if (diff == null) {
                    return null;
                }
                Integer temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateDateDiff(cells[i][columnArrayIndex], cells[i - 1][columnArrayIndex], configRegistry);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * rowDiff;
            }
        }
        return null;
    }

    protected Number calculateVerticalDiff(ILayerCell cell, int toColumn, IConfigRegistry configRegistry) {
        Class<?> type = cell.getDataValue() != null ? cell.getDataValue().getClass() : null;
        ILayerCell[][] cells = this.clipboard.getCopiedCells();
        int columnDiff = this.getColumnDiff(cell, toColumn);
        int rowArrayIndex = cell.getRowIndex() - this.clipboard.getCopiedCells()[0][0].getRowIndex();
        if (cells[rowArrayIndex].length == 1) {
            return this.getCastValue(columnDiff, type);
        }
        if (type != null) {
            if (type == Byte.class) {
                Byte diff = this.calculateByteDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Byte temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateByteDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return (byte)(diff * columnDiff);
            }
            if (type == Short.class) {
                Short diff = this.calculateShortDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Short temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateShortDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return (short)(diff * columnDiff);
            }
            if (type == Integer.class) {
                Integer diff = this.calculateIntDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Integer temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateIntDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * columnDiff;
            }
            if (type == Long.class) {
                Long diff = this.calculateLongDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Long temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateLongDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * (long)columnDiff;
            }
            if (type == Float.class) {
                Float diff = this.calculateFloatDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Float temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateFloatDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return Float.valueOf(BigDecimal.valueOf(diff.floatValue()).multiply(BigDecimal.valueOf(columnDiff)).floatValue());
            }
            if (type == Double.class) {
                Double diff = this.calculateDoubleDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                Double temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateDoubleDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return BigDecimal.valueOf(diff).multiply(BigDecimal.valueOf(columnDiff)).doubleValue();
            }
            if (type == BigInteger.class) {
                BigInteger diff = this.calculateBigIntegerDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                BigInteger temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateBigIntegerDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff.multiply(BigInteger.valueOf(columnDiff));
            }
            if (type == BigDecimal.class) {
                BigDecimal diff = this.calculateBigDecimalDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0]);
                if (diff == null) {
                    return null;
                }
                BigDecimal temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateBigDecimalDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1]);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff.multiply(BigDecimal.valueOf(columnDiff));
            }
            if (type == Date.class) {
                Integer diff = this.calculateDateDiff(cells[rowArrayIndex][1], cells[rowArrayIndex][0], configRegistry);
                if (diff == null) {
                    return null;
                }
                Integer temp = diff;
                int i = 1;
                while (i < cells.length) {
                    temp = this.calculateDateDiff(cells[rowArrayIndex][i], cells[rowArrayIndex][i - 1], configRegistry);
                    if (temp == null || !temp.equals(diff)) {
                        return null;
                    }
                    ++i;
                }
                return diff * columnDiff;
            }
        }
        return null;
    }

    protected int getRowDiff(ILayerCell currentCell, int toRow) {
        return toRow - currentCell.getRowIndex();
    }

    protected int getColumnDiff(ILayerCell currentCell, int toColumn) {
        return toColumn - currentCell.getColumnIndex();
    }

    protected Number getCastValue(int diff, Class<?> type) {
        if (type != null) {
            if (type == Byte.class) {
                return (byte)diff;
            }
            if (type == Short.class) {
                return (short)diff;
            }
            if (type == Long.class) {
                return (long)diff;
            }
            if (type == Float.class) {
                return Float.valueOf(diff);
            }
            if (type == Double.class) {
                return (double)diff;
            }
            if (type == BigInteger.class) {
                return BigInteger.valueOf(diff);
            }
            if (type == BigDecimal.class) {
                return BigDecimal.valueOf(diff);
            }
        }
        return diff;
    }

    protected Byte calculateByteDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Byte) || !(c2.getDataValue() instanceof Byte) ? null : Byte.valueOf((byte)((Byte)c1.getDataValue() - (Byte)c2.getDataValue()));
    }

    protected Short calculateShortDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Short) || !(c2.getDataValue() instanceof Short) ? null : Short.valueOf((short)((Short)c1.getDataValue() - (Short)c2.getDataValue()));
    }

    protected Integer calculateIntDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Integer) || !(c2.getDataValue() instanceof Integer) ? null : Integer.valueOf((Integer)c1.getDataValue() - (Integer)c2.getDataValue());
    }

    protected Long calculateLongDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Long) || !(c2.getDataValue() instanceof Long) ? null : Long.valueOf((Long)c1.getDataValue() - (Long)c2.getDataValue());
    }

    protected Float calculateFloatDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Float) || !(c2.getDataValue() instanceof Float)) {
            return null;
        }
        BigDecimal v1 = new BigDecimal(c1.getDataValue().toString());
        BigDecimal v2 = new BigDecimal(c2.getDataValue().toString());
        return Float.valueOf(v1.subtract(v2).floatValue());
    }

    protected Double calculateDoubleDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Double) || !(c2.getDataValue() instanceof Double)) {
            return null;
        }
        BigDecimal v1 = new BigDecimal(c1.getDataValue().toString());
        BigDecimal v2 = new BigDecimal(c2.getDataValue().toString());
        return v1.subtract(v2).doubleValue();
    }

    protected BigInteger calculateBigIntegerDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof BigInteger) || !(c2.getDataValue() instanceof BigInteger) ? null : ((BigInteger)c1.getDataValue()).subtract((BigInteger)c2.getDataValue());
    }

    protected BigDecimal calculateBigDecimalDiff(ILayerCell c1, ILayerCell c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof BigDecimal) || !(c2.getDataValue() instanceof BigDecimal) ? null : ((BigDecimal)c1.getDataValue()).subtract((BigDecimal)c2.getDataValue());
    }

    protected Integer calculateDateDiff(ILayerCell c1, ILayerCell c2, IConfigRegistry configRegistry) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.getDataValue() == null || c2.getDataValue() == null || !(c1.getDataValue() instanceof Date) || !(c2.getDataValue() instanceof Date)) {
            return null;
        }
        int dateField = this.getIncrementDateField(c1, configRegistry);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime((Date)c1.getDataValue());
        int fieldValue1 = cal1.get(dateField);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime((Date)c2.getDataValue());
        int fieldValue2 = cal2.get(dateField);
        return fieldValue1 - fieldValue2;
    }

    protected int getIncrementDateField(ILayerCell cell, IConfigRegistry configRegistry) {
        Integer dateField = configRegistry.getConfigAttribute(FillHandleConfigAttributes.INCREMENT_DATE_FIELD, DisplayMode.NORMAL, (List<String>)cell.getConfigLabels());
        if (dateField == null) {
            dateField = 5;
        }
        return dateField;
    }

    @Override
    public Class<FillHandlePasteCommand> getCommandClass() {
        return FillHandlePasteCommand.class;
    }
}

