/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaDateTimeTests
extends TestCase {
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;

    public void setUp() throws Exception {
        this.repository = new TaskRepository("bugzilla", "http://mylyn.org");
        this.connector = new BugzillaRepositoryConnector();
    }

    public void testDateFormatParsing() {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            TaskData taskData = new TaskData((TaskAttributeMapper)new BugzillaAttributeMapper(this.repository, this.connector), "bugzilla", "repourl", "1");
            TaskAttribute attribute = taskData.getRoot().createAttribute(BugzillaAttribute.CREATION_TS.getKey());
            attribute.setValue("2006-05-08 15:04 PST");
            Date date = taskData.getAttributeMapper().getDateValue(attribute);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)23, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(13));
            attribute.setValue("2006-05-08 15:04:11 PST");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)23, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)11, (int)calendar.get(13));
            attribute.setValue("2006-05-08 15:04:11 -0800");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)23, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)11, (int)calendar.get(13));
            attribute.setValue("2006-05-08 15:04 -0800");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)23, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(13));
            attribute.setValue("2006-05-08 15:04:11");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)15, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)11, (int)calendar.get(13));
            attribute.setValue("2006-05-08 15:04");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)15, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(13));
            attribute.setValue("2006-05-08");
            date = taskData.getAttributeMapper().getDateValue(attribute);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            BugzillaDateTimeTests.assertEquals((int)2006, (int)calendar.get(1));
            BugzillaDateTimeTests.assertEquals((int)4, (int)calendar.get(2));
            BugzillaDateTimeTests.assertEquals((int)8, (int)calendar.get(5));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(11));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(12));
            BugzillaDateTimeTests.assertEquals((int)0, (int)calendar.get(13));
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }
}

