/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;

public class AbstractRepositoryConnectorUiTest
extends TestCase {
    private AbstractRepositoryConnectorUi connectorUi;
    private TaskRepository repository;
    private TaskAttribute commentAttribute;
    private MockTask task;

    protected void setUp() throws Exception {
        this.connectorUi = new MockRepositoryConnectorUi();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        this.task = new MockTask("1");
        TaskAttributeMapper mapper = new TaskAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, "mock", "http://mockrepository.test", "1");
        this.commentAttribute = taskData.getRoot().createAttribute("comment");
    }

    public void testGetReplyTextDescription() throws Exception {
        TaskTask task = new TaskTask("abc", "http://eclipse.org/mylyn", "1");
        String replyText = this.connectorUi.getReplyText(null, (ITask)task, null, false);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to comment #0)", (String)replyText);
    }

    public void testGetReplyTextSpecificComment() throws Exception {
        TaskComment taskComment = new TaskComment(this.repository, (ITask)this.task, this.commentAttribute){

            public int getNumber() {
                return 13;
            }
        };
        String replyText = this.connectorUi.getReplyText(null, (ITask)this.task, (ITaskComment)taskComment, false);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to comment #13)", (String)replyText);
    }

    public void testGetReplyTextSpecificCommentOnTask() throws Exception {
        TaskComment taskComment = new TaskComment(this.repository, (ITask)this.task, this.commentAttribute){

            public int getNumber() {
                return 13;
            }
        };
        String replyText = this.connectorUi.getReplyText(null, (ITask)this.task, (ITaskComment)taskComment, true);
        AbstractRepositoryConnectorUiTest.assertEquals((String)"(In reply to 1 comment #13)", (String)replyText);
    }
}

