/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.support;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorBranding;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;

public class MockRepositoryConnectorAdapter
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{AbstractRepositoryConnector.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof MockRepositoryConnector) {
            AbstractRepositoryConnector connector = (AbstractRepositoryConnector)adaptableObject;
            if (adapterType == AbstractRepositoryConnectorUi.class) {
                return new DynamicMockRepositoryConnectorUi(connector);
            }
            if (adapterType == RepositoryConnectorBranding.class) {
                return new RepositoryConnectorBranding(){

                    public InputStream getOverlayImageData() throws IOException {
                        return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-overlay.gif");
                    }

                    public InputStream getBrandingImageData() throws IOException {
                        return CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/icons/mock-repository.gif");
                    }
                };
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public static final class DynamicMockRepositoryConnectorUi
    extends MockRepositoryConnectorUi {
        private final AbstractRepositoryConnector connector;

        DynamicMockRepositoryConnectorUi(AbstractRepositoryConnector connector) {
            this.connector = connector;
        }

        @Override
        public String getConnectorKind() {
            return this.connector.getConnectorKind();
        }
    }
}

