/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskDiffUtilTest
extends TestCase {
    public void testFoldSpaces() {
        TaskDiffUtilTest.assertEquals((String)"a b", (String)TaskDiffUtil.foldSpaces((String)"a   b"));
        TaskDiffUtilTest.assertEquals((String)"", (String)TaskDiffUtil.foldSpaces((String)"  "));
        TaskDiffUtilTest.assertEquals((String)"a b c d", (String)TaskDiffUtil.cleanCommentText((String)"a   b c   d"));
        TaskDiffUtilTest.assertEquals((String)"b", (String)TaskDiffUtil.cleanCommentText((String)"   b   "));
        TaskDiffUtilTest.assertEquals((String)"b", (String)TaskDiffUtil.cleanCommentText((String)"   b"));
    }

    public void testCleanComment() {
        TaskDiffUtilTest.assertEquals((String)"attachment: some attachment. attachment description", (String)TaskDiffUtil.cleanCommentText((String)"Created an attachment (id=111)\nsome attachment\n\nattachment description"));
        TaskDiffUtilTest.assertEquals((String)"attachment: some attachment", (String)TaskDiffUtil.cleanCommentText((String)"Created an attachment (id=111)\nsome attachment\n\n"));
        TaskDiffUtilTest.assertEquals((String)"some comment", (String)TaskDiffUtil.cleanCommentText((String)"(In reply to comment #11)\nsome comment\n"));
        TaskDiffUtilTest.assertEquals((String)"some comment. other comment", (String)TaskDiffUtil.cleanCommentText((String)" (In reply to comment #11)\nsome comment\n\n (In reply to comment #12)\nother comment\n"));
        TaskDiffUtilTest.assertEquals((String)"some comment. other comment", (String)TaskDiffUtil.cleanCommentText((String)" (In reply to comment #11)\nsome comment.  \n\n (In reply to comment #12)\n> loren ipsum\n> loren ipsum\nother comment\n"));
    }

    public void testDateDiff() {
        TaskData dataA = new TaskData((TaskAttributeMapper)new MyTaskAttributeMapper(new TaskRepository("mock", "url")), "mock", "url", "1123");
        TaskAttribute attributeA = new TaskAttribute(dataA.getRoot(), "attributeA");
        attributeA.getMetaData().setKind("task.common.kind.default").setType("date").setLabel("someDate:");
        attributeA.setValue("1275068800000");
        TaskData dataB = new TaskData((TaskAttributeMapper)new MyTaskAttributeMapper(new TaskRepository("mock", "url")), "mock", "url", "1123");
        TaskAttribute attributeB = new TaskAttribute(dataB.getRoot(), "attributeA");
        attributeB.getMetaData().setKind("task.common.kind.default").setType("date").setLabel("mydate");
        attributeB.setValue("1265068800000");
        TaskDataDiff diff = new TaskDataDiff(new RepositoryModel(new TaskList(), (IRepositoryManager)new TaskRepositoryManager()), dataA, dataB);
        TaskDiffUtilTest.assertEquals((String)" someDate: 2010/02/01 -> 2010/05/28", (String)TaskDiffUtil.toString((TaskDataDiff)diff));
    }

    static class MyTaskAttributeMapper
    extends TaskAttributeMapper {
        public MyTaskAttributeMapper(TaskRepository taskRepository) {
            super(taskRepository);
        }

        public String getValueLabel(TaskAttribute taskAttribute) {
            if (taskAttribute.getMetaData().getType() == "date") {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(Long.parseLong(taskAttribute.getValue()));
                return new SimpleDateFormat("yyyy/MM/dd").format(cal.getTime());
            }
            return super.getValueLabel(taskAttribute);
        }

        public List<String> getValueLabels(TaskAttribute taskAttribute) {
            if (taskAttribute.getMetaData().getType() == "date") {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(Long.parseLong(taskAttribute.getValue()));
                return Collections.singletonList(new SimpleDateFormat("yyyy/MM/dd").format(cal.getTime()));
            }
            return super.getValueLabels(taskAttribute);
        }
    }
}

